/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model.config.consts;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=TeammateNameDisplayDeserializer.class)
public enum TeammateNameDisplay implements HasCode<TeammateNameDisplay>
{
    UserName("username"),
    NickNameFullName("nickname_full_name"),
    FullName("full_name");

    private final String code;

    public static TeammateNameDisplay of(String code) {
        return Arrays.stream(TeammateNameDisplay.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(null);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    private TeammateNameDisplay(String code) {
        this.code = code;
    }

    public static class TeammateNameDisplayDeserializer
    extends JsonDeserializer<TeammateNameDisplay> {
        public TeammateNameDisplay deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String jsonValue = p.getText();
            return TeammateNameDisplay.of(jsonValue);
        }
    }
}

