/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=CommandResponseTypeDeserializer.class)
public enum CommandResponseType implements HasCode<CommandResponseType>
{
    InChannel("in_channel"),
    Ephemeral("ephemeral");

    private final String code;

    private CommandResponseType(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public static CommandResponseType of(String code) {
        for (CommandResponseType type : CommandResponseType.values()) {
            if (!type.getCode().equals(code)) continue;
            return type;
        }
        return null;
    }

    public static class CommandResponseTypeDeserializer
    extends JsonDeserializer<CommandResponseType> {
        public CommandResponseType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String code = p.getText();
            return CommandResponseType.of(code);
        }
    }
}

