/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model.config.consts;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=ImageDriverDeserializer.class)
public enum ImageDriver implements HasCode<ImageDriver>
{
    LOCAL("local"),
    S3("amazons3");

    private final String code;

    private ImageDriver(String code) {
        this.code = code;
    }

    public static ImageDriver of(String code) {
        return Arrays.stream(ImageDriver.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(null);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public static class ImageDriverDeserializer
    extends JsonDeserializer<ImageDriver> {
        public ImageDriver deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String jsonValue = p.getText();
            return ImageDriver.of(jsonValue);
        }
    }
}

