/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ElasticsearchSettings {
    private String connectionUrl;
    private String username;
    private String password;
    private boolean enableIndexing;
    private boolean enableSearching;
    private boolean sniff = true;
    private int postIndexReplicas;
    private int postIndexShards;
    private int aggregatePostsAfterDays = 365;
    private String postsAggregatorJobStartTime = "03:00";
    private String indexPrefix;
    private int liveIndexingBatchSize = 1;
    private int requestTimeoutSeconds = 30;
    private int bulkIndexingTimeWindowSeconds = 3600;

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isEnableIndexing() {
        return this.enableIndexing;
    }

    public boolean isEnableSearching() {
        return this.enableSearching;
    }

    public boolean isSniff() {
        return this.sniff;
    }

    public int getPostIndexReplicas() {
        return this.postIndexReplicas;
    }

    public int getPostIndexShards() {
        return this.postIndexShards;
    }

    public int getAggregatePostsAfterDays() {
        return this.aggregatePostsAfterDays;
    }

    public String getPostsAggregatorJobStartTime() {
        return this.postsAggregatorJobStartTime;
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    public int getLiveIndexingBatchSize() {
        return this.liveIndexingBatchSize;
    }

    public int getRequestTimeoutSeconds() {
        return this.requestTimeoutSeconds;
    }

    public int getBulkIndexingTimeWindowSeconds() {
        return this.bulkIndexingTimeWindowSeconds;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEnableIndexing(boolean enableIndexing) {
        this.enableIndexing = enableIndexing;
    }

    public void setEnableSearching(boolean enableSearching) {
        this.enableSearching = enableSearching;
    }

    public void setSniff(boolean sniff) {
        this.sniff = sniff;
    }

    public void setPostIndexReplicas(int postIndexReplicas) {
        this.postIndexReplicas = postIndexReplicas;
    }

    public void setPostIndexShards(int postIndexShards) {
        this.postIndexShards = postIndexShards;
    }

    public void setAggregatePostsAfterDays(int aggregatePostsAfterDays) {
        this.aggregatePostsAfterDays = aggregatePostsAfterDays;
    }

    public void setPostsAggregatorJobStartTime(String postsAggregatorJobStartTime) {
        this.postsAggregatorJobStartTime = postsAggregatorJobStartTime;
    }

    public void setIndexPrefix(String indexPrefix) {
        this.indexPrefix = indexPrefix;
    }

    public void setLiveIndexingBatchSize(int liveIndexingBatchSize) {
        this.liveIndexingBatchSize = liveIndexingBatchSize;
    }

    public void setRequestTimeoutSeconds(int requestTimeoutSeconds) {
        this.requestTimeoutSeconds = requestTimeoutSeconds;
    }

    public void setBulkIndexingTimeWindowSeconds(int bulkIndexingTimeWindowSeconds) {
        this.bulkIndexingTimeWindowSeconds = bulkIndexingTimeWindowSeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticsearchSettings)) {
            return false;
        }
        ElasticsearchSettings other = (ElasticsearchSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$connectionUrl = this.getConnectionUrl();
        String other$connectionUrl = other.getConnectionUrl();
        if (this$connectionUrl == null ? other$connectionUrl != null : !this$connectionUrl.equals(other$connectionUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        if (this.isEnableIndexing() != other.isEnableIndexing()) {
            return false;
        }
        if (this.isEnableSearching() != other.isEnableSearching()) {
            return false;
        }
        if (this.isSniff() != other.isSniff()) {
            return false;
        }
        if (this.getPostIndexReplicas() != other.getPostIndexReplicas()) {
            return false;
        }
        if (this.getPostIndexShards() != other.getPostIndexShards()) {
            return false;
        }
        if (this.getAggregatePostsAfterDays() != other.getAggregatePostsAfterDays()) {
            return false;
        }
        String this$postsAggregatorJobStartTime = this.getPostsAggregatorJobStartTime();
        String other$postsAggregatorJobStartTime = other.getPostsAggregatorJobStartTime();
        if (this$postsAggregatorJobStartTime == null ? other$postsAggregatorJobStartTime != null : !this$postsAggregatorJobStartTime.equals(other$postsAggregatorJobStartTime)) {
            return false;
        }
        String this$indexPrefix = this.getIndexPrefix();
        String other$indexPrefix = other.getIndexPrefix();
        if (this$indexPrefix == null ? other$indexPrefix != null : !this$indexPrefix.equals(other$indexPrefix)) {
            return false;
        }
        if (this.getLiveIndexingBatchSize() != other.getLiveIndexingBatchSize()) {
            return false;
        }
        if (this.getRequestTimeoutSeconds() != other.getRequestTimeoutSeconds()) {
            return false;
        }
        return this.getBulkIndexingTimeWindowSeconds() == other.getBulkIndexingTimeWindowSeconds();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticsearchSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $connectionUrl = this.getConnectionUrl();
        result = result * 59 + ($connectionUrl == null ? 43 : $connectionUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + (this.isEnableIndexing() ? 79 : 97);
        result = result * 59 + (this.isEnableSearching() ? 79 : 97);
        result = result * 59 + (this.isSniff() ? 79 : 97);
        result = result * 59 + this.getPostIndexReplicas();
        result = result * 59 + this.getPostIndexShards();
        result = result * 59 + this.getAggregatePostsAfterDays();
        String $postsAggregatorJobStartTime = this.getPostsAggregatorJobStartTime();
        result = result * 59 + ($postsAggregatorJobStartTime == null ? 43 : $postsAggregatorJobStartTime.hashCode());
        String $indexPrefix = this.getIndexPrefix();
        result = result * 59 + ($indexPrefix == null ? 43 : $indexPrefix.hashCode());
        result = result * 59 + this.getLiveIndexingBatchSize();
        result = result * 59 + this.getRequestTimeoutSeconds();
        result = result * 59 + this.getBulkIndexingTimeWindowSeconds();
        return result;
    }

    public String toString() {
        return "ElasticsearchSettings(connectionUrl=" + this.getConnectionUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", enableIndexing=" + this.isEnableIndexing() + ", enableSearching=" + this.isEnableSearching() + ", sniff=" + this.isSniff() + ", postIndexReplicas=" + this.getPostIndexReplicas() + ", postIndexShards=" + this.getPostIndexShards() + ", aggregatePostsAfterDays=" + this.getAggregatePostsAfterDays() + ", postsAggregatorJobStartTime=" + this.getPostsAggregatorJobStartTime() + ", indexPrefix=" + this.getIndexPrefix() + ", liveIndexingBatchSize=" + this.getLiveIndexingBatchSize() + ", requestTimeoutSeconds=" + this.getRequestTimeoutSeconds() + ", bulkIndexingTimeWindowSeconds=" + this.getBulkIndexingTimeWindowSeconds() + ")";
    }
}

