/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=ComplianceTypeDeserializer.class)
public enum ComplianceType implements HasCode<ComplianceType>
{
    Daily("daily"),
    Adhoc("adhoc");

    private final String code;

    private ComplianceType(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public static ComplianceType of(String code) {
        return Arrays.asList(ComplianceType.values()).stream().filter(t -> t.getCode().equals(code)).findFirst().orElse(null);
    }

    public static class ComplianceTypeDeserializer
    extends JsonDeserializer<ComplianceType> {
        public ComplianceType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String code = p.getText();
            return ComplianceType.of(code);
        }
    }
}

