/*
 * Decompiled with CFR 0.152.
 */
package net.binggl.commons.crypto;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.binggl.commons.util.ExceptionHelper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesEncryption {
    private static final String CIPHER_INSTANCE = "AES/CBC/PKCS5PADDING";
    private static final String ALGORITHM_AES = "AES";
    private static final String ALGORITHM_SHA = "SHA-256";
    private static final int KEY_SIZE = 16;
    private static final Logger logger = LoggerFactory.getLogger(AesEncryption.class);
    private static final int IV_VECTOR_LENGTH = 16;

    public String encrypt(String string, String string2) {
        if (StringUtils.isNotEmpty((CharSequence)string2)) {
            return ExceptionHelper.wrapEx(() -> this.encrypt(string, string2.getBytes(StandardCharsets.UTF_8)));
        }
        return null;
    }

    public String encrypt(String string, byte[] byArray) {
        try {
            byte[] byArray2 = new byte[16];
            ThreadLocalRandom.current().nextBytes(byArray2);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.generateKey(string), ALGORITHM_AES);
            Cipher cipher = Cipher.getInstance(CIPHER_INSTANCE);
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            byte[] byArray3 = cipher.doFinal(byArray);
            byArray3 = ArrayUtils.addAll((byte[])ivParameterSpec.getIV(), (byte[])byArray3);
            return Base64.encodeBase64String((byte[])byArray3);
        }
        catch (Exception exception) {
            logger.error("Could not perform encryption: {}", (Object)exception.getMessage(), (Object)exception);
            return null;
        }
    }

    public String decryptAsString(String string, String string2) {
        if (StringUtils.isNotEmpty((CharSequence)string2)) {
            return ExceptionHelper.wrapEx(() -> new String(this.decrypt(string, string2)));
        }
        return null;
    }

    public byte[] decrypt(String string, String string2) {
        return this.decrypt(string, Base64.decodeBase64((String)string2));
    }

    public byte[] decrypt(String string, byte[] byArray) {
        try {
            byte[] byArray2 = byArray;
            byte[] byArray3 = Arrays.copyOf(byArray2, 16);
            byte[] byArray4 = Arrays.copyOfRange(byArray2, 16, byArray2.length);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.generateKey(string), ALGORITHM_AES);
            Cipher cipher = Cipher.getInstance(CIPHER_INSTANCE);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byte[] byArray5 = cipher.doFinal(byArray4);
            return byArray5;
        }
        catch (Exception exception) {
            logger.error("Could not perform decryption: {}", (Object)exception.getMessage(), (Object)exception);
            return null;
        }
    }

    private byte[] generateKey(String string) {
        return ExceptionHelper.wrapEx(() -> {
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            MessageDigest messageDigest = MessageDigest.getInstance(ALGORITHM_SHA);
            byArray = messageDigest.digest(byArray);
            byArray = Arrays.copyOf(byArray, 16);
            return byArray;
        });
    }
}

