/*
 * Decompiled with CFR 0.152.
 */
package net.binggl.commons.util;

import net.binggl.commons.exceptions.LogRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHelper {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHelper.class);

    public static void wrapEx(Block block) {
        try {
            block.go();
        }
        catch (Exception exception) {
            throw new LogRuntimeException(exception);
        }
    }

    public static <T> T wrapEx(NoArgFn<T> noArgFn) {
        try {
            return noArgFn.go();
        }
        catch (Exception exception) {
            throw new LogRuntimeException(exception);
        }
    }

    public static void logEx(Block block) {
        try {
            block.go();
        }
        catch (Exception exception) {
            logger.error("Got exception, message: {}, cause: {}", (Object)exception.getMessage(), (Object)exception);
        }
    }

    public static <T> T logEx(NoArgFn<T> noArgFn) {
        try {
            return noArgFn.go();
        }
        catch (Exception exception) {
            logger.error("Got exception, message: {}, cause: {}", (Object)exception.getMessage(), (Object)exception);
            return null;
        }
    }

    public static interface NoArgFn<T> {
        public T go() throws Exception;
    }

    public static interface Block {
        public void go() throws Exception;
    }
}

