/*
 * Decompiled with CFR 0.152.
 */
package net.binggl.commons.exceptions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRuntimeException
extends RuntimeException {
    private static final Logger logger = LoggerFactory.getLogger(LogRuntimeException.class);
    private static final long serialVersionUID = 1L;

    public LogRuntimeException() {
        logger.error("Got an exception");
    }

    public LogRuntimeException(String string) {
        super(string);
        logger.error("Got an exception, message {}", (Object)string);
    }

    public LogRuntimeException(Throwable throwable) {
        super(throwable);
        logger.error("Got exception, cause {}", throwable);
    }

    public LogRuntimeException(Exception exception) {
        super(exception);
        logger.error("Got exception {}, stack {}", (Object)exception.getMessage(), (Object)exception);
    }

    public LogRuntimeException(String string, Throwable throwable) {
        super(string, throwable);
        logger.error("Got exception, message: {}, cause: {}", (Object)string, (Object)throwable);
    }

    public LogRuntimeException(String string, Throwable throwable, boolean bl, boolean bl2) {
        super(string, throwable, bl, bl2);
        logger.error("Got exception, message: {}, cause: {}", (Object)string, (Object)throwable);
    }
}

