/*
 * Decompiled with CFR 0.152.
 */
package net.binggl.commons.crypto;

import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.binggl.commons.util.ExceptionHelper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesEncryption {
    private static final String CIPHER_INSTANCE = "AES/CBC/PKCS5PADDING";
    private static final String ENCODING = "UTF-8";
    private static final String ALGORITHM_AES = "AES";
    private static final String ALGORITHM_SHA = "SHA-256";
    private static final Logger logger = LoggerFactory.getLogger(AesEncryption.class);
    private static final int IV_VECTOR_LENGHT = 16;

    public String encrypt(String string, String string2) {
        try {
            byte[] byArray = new byte[16];
            ThreadLocalRandom.current().nextBytes(byArray);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.generateKey(string), ALGORITHM_AES);
            Cipher cipher = Cipher.getInstance(CIPHER_INSTANCE);
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            byte[] byArray2 = cipher.doFinal(string2.getBytes());
            byArray2 = ArrayUtils.addAll((byte[])ivParameterSpec.getIV(), (byte[])byArray2);
            return Base64.encodeBase64String((byte[])byArray2);
        }
        catch (Exception exception) {
            logger.error("Could not perform encryption: {}", (Object)exception.getMessage(), (Object)exception);
            return null;
        }
    }

    public String decrypt(String string, String string2) {
        try {
            byte[] byArray = Base64.decodeBase64((String)string2);
            byte[] byArray2 = Arrays.copyOf(byArray, 16);
            byte[] byArray3 = Arrays.copyOfRange(byArray, 16, byArray.length);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.generateKey(string), ALGORITHM_AES);
            Cipher cipher = Cipher.getInstance(CIPHER_INSTANCE);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byte[] byArray4 = cipher.doFinal(byArray3);
            return new String(byArray4);
        }
        catch (Exception exception) {
            logger.error("Could not perform decryption: {}", (Object)exception.getMessage(), (Object)exception);
            return null;
        }
    }

    private byte[] generateKey(String string) {
        return ExceptionHelper.wrapEx(() -> {
            byte[] byArray = string.getBytes(ENCODING);
            MessageDigest messageDigest = MessageDigest.getInstance(ALGORITHM_SHA);
            byArray = messageDigest.digest(byArray);
            byArray = Arrays.copyOf(byArray, 16);
            return byArray;
        });
    }
}

