/*
 * Decompiled with CFR 0.152.
 */
package net.bhardy.bizzo.billing.impl;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.bhardy.bizzo.billing.ActionChoice;
import net.bhardy.bizzo.billing.BillingPolicy;
import net.bhardy.bizzo.billing.CycleType;
import net.bhardy.bizzo.billing.FilterOption;
import net.bhardy.bizzo.billing.PolicyBuilder;
import net.bhardy.bizzo.billing.PolicyFilter;
import net.bhardy.bizzo.billing.impl.ActionChoiceBuilder;

public class PolicyBuilderImpl
implements PolicyBuilder {
    private static final int DAYS_PER_WEEK = 7;

    @Override
    public FilterOption everyDay() {
        BillingPolicy base = new BillingPolicy(){

            @Override
            public boolean isDueOn(LocalDate day) {
                return true;
            }

            @Override
            public List<LocalDate> upcomingDueDates(LocalDate day, int howMany) {
                ArrayList<LocalDate> results = new ArrayList<LocalDate>();
                for (int num = 0; num < howMany; ++num) {
                    results.add(day.plusDays(num));
                }
                return results;
            }

            @Override
            public CycleType getCycleType() {
                return CycleType.DAILY;
            }
        };
        return this.buildFilterOption(base);
    }

    @Override
    public FilterOption sameDayEveryWeek(final DayOfWeek onWhichDay) {
        BillingPolicy base = new BillingPolicy(){

            @Override
            public boolean isDueOn(LocalDate day) {
                return day.getDayOfWeek().equals(onWhichDay);
            }

            @Override
            public List<LocalDate> upcomingDueDates(LocalDate day, int howMany) {
                DayOfWeek todayIsA = day.getDayOfWeek();
                int daysTilNext = (onWhichDay.getValue() + 7 - todayIsA.getValue()) % 7;
                LocalDate first = day.plusDays(daysTilNext);
                ArrayList<LocalDate> results = new ArrayList<LocalDate>();
                for (int num = 0; num < howMany; ++num) {
                    results.add(first.plusWeeks(num));
                }
                return results;
            }

            @Override
            public CycleType getCycleType() {
                return CycleType.WEEKLY;
            }
        };
        return this.buildFilterOption(base);
    }

    @Override
    public FilterOption sameDayEveryMonth(final int dayOfMonth) {
        BillingPolicy base = new BillingPolicy(){

            @Override
            public boolean isDueOn(LocalDate day) {
                return day.getDayOfMonth() == dayOfMonth;
            }

            @Override
            public List<LocalDate> upcomingDueDates(LocalDate day, int howMany) {
                int monthOffset = day.getDayOfMonth() > dayOfMonth ? 1 : 0;
                LocalDate first = day.withDayOfMonth(dayOfMonth).plusMonths(monthOffset);
                return IntStream.range(0, howMany).mapToObj(first::plusMonths).collect(Collectors.toList());
            }

            @Override
            public CycleType getCycleType() {
                return CycleType.MONTHLY;
            }
        };
        return this.buildFilterOption(base);
    }

    FilterOption buildFilterOption(final BillingPolicy underlyingPolicy) {
        return new FilterOption(){

            @Override
            public BillingPolicy build() {
                return underlyingPolicy;
            }

            @Override
            public ActionChoice filter(PolicyFilter filter) {
                return new ActionChoiceBuilder(PolicyBuilderImpl.this, underlyingPolicy, filter);
            }
        };
    }
}

