/*
 * Decompiled with CFR 0.152.
 */
package net.bhardy.bizzo.billing.impl;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import net.bhardy.bizzo.billing.ActionChoice;
import net.bhardy.bizzo.billing.BillingPolicy;
import net.bhardy.bizzo.billing.CycleType;
import net.bhardy.bizzo.billing.FilterOption;
import net.bhardy.bizzo.billing.PolicyFilter;
import net.bhardy.bizzo.billing.impl.PolicyBuilderImpl;

final class ActionChoiceBuilder
implements ActionChoice {
    private final PolicyBuilderImpl policyBuilder;
    private final BillingPolicy underlyingPolicy;
    private final PolicyFilter filter;

    ActionChoiceBuilder(PolicyBuilderImpl policyBuilder, BillingPolicy underlyingPolicy, PolicyFilter filter) {
        this.policyBuilder = policyBuilder;
        this.underlyingPolicy = underlyingPolicy;
        this.filter = filter;
    }

    @Override
    public FilterOption action(final ActionChoice.Kind actionKind) {
        BillingPolicy layered = new BillingPolicy(){

            @Override
            public boolean isDueOn(LocalDate today) {
                return ActionChoiceBuilder.this.underlyingPolicy.isDueOn(today) && ActionChoiceBuilder.this.filter.applies(today);
            }

            @Override
            public List<LocalDate> upcomingDueDates(LocalDate day, int howMany) {
                return ActionChoiceBuilder.this.filterDates(day, howMany, actionKind);
            }

            @Override
            public CycleType getCycleType() {
                return ActionChoiceBuilder.this.underlyingPolicy.getCycleType();
            }
        };
        return this.policyBuilder.buildFilterOption(layered);
    }

    private List<LocalDate> filterDates(LocalDate day, int howMany, ActionChoice.Kind actionKind) {
        List<LocalDate> considering = this.underlyingPolicy.upcomingDueDates(day, howMany);
        ArrayList<LocalDate> filtered = new ArrayList<LocalDate>();
        for (LocalDate when : considering) {
            if ((when = this.adjustDateIfNeeded(when, actionKind)) == null || when.isBefore(day)) continue;
            filtered.add(when);
        }
        return filtered;
    }

    private LocalDate adjustDateIfNeeded(LocalDate when, ActionChoice.Kind actionKind) {
        while (when != null && !this.filter.applies(when)) {
            switch (actionKind) {
                case PREVIOUS_DAY: {
                    when = when.minusDays(1L);
                    break;
                }
                case NEXT_DAY: {
                    when = when.plusDays(1L);
                    break;
                }
                case SKIP: {
                    when = null;
                }
            }
        }
        return when;
    }
}

