/*
 * Decompiled with CFR 0.152.
 */
package net.bhardy.bizzo.billing;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface PolicyFilter {
    public boolean applies(LocalDate var1);

    public static PolicyFilter daysOfWeek(DayOfWeek ... days) {
        Set fallingDays = Stream.of(days).collect(Collectors.toSet());
        return today -> fallingDays.contains(today.getDayOfWeek());
    }

    public static PolicyFilter not(PolicyFilter other) {
        return today -> !other.applies(today);
    }
}

