/*
 * Decompiled with CFR 0.152.
 */
package net.bhardy.bizzo.billing;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.List;
import net.bhardy.bizzo.billing.ActionChoice;
import net.bhardy.bizzo.billing.BillingPolicy;
import net.bhardy.bizzo.billing.PolicyFilter;
import org.junit.Assert;
import org.junit.Test;

public class PolicyBuilderTest {
    @Test
    public void testBuilder() {
        BillingPolicy policy = BillingPolicy.builder().sameDayEveryMonth(5).filter(PolicyFilter.not((PolicyFilter)PolicyFilter.daysOfWeek((DayOfWeek[])new DayOfWeek[]{DayOfWeek.SATURDAY, DayOfWeek.SUNDAY}))).action(ActionChoice.Kind.NEXT_DAY).build();
        LocalDate oneSaturday = LocalDate.of(2017, 8, 5);
        Assert.assertFalse((boolean)policy.isDueOn(oneSaturday));
        List nextBills = policy.upcomingDueDates(oneSaturday, 2);
        LocalDate expected1 = LocalDate.of(2017, 8, 7);
        LocalDate actual1 = (LocalDate)nextBills.get(0);
        Assert.assertEquals((Object)expected1, (Object)actual1);
        Assert.assertEquals((Object)DayOfWeek.MONDAY, (Object)actual1.getDayOfWeek());
        LocalDate expected2 = LocalDate.of(2017, 9, 5);
        LocalDate actual2 = (LocalDate)nextBills.get(1);
        Assert.assertEquals((Object)expected2, (Object)actual2);
        Assert.assertEquals((Object)DayOfWeek.TUESDAY, (Object)actual2.getDayOfWeek());
    }
}

