/*
 * Decompiled with CFR 0.152.
 */
package net.benpl.r2dbc.support;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.NonNull;
import net.benpl.r2dbc.annotation.Column;
import net.benpl.r2dbc.annotation.IdClass;
import net.benpl.r2dbc.annotation.Table;
import net.benpl.r2dbc.exception.R2dbcException;
import net.benpl.r2dbc.support.Utils;

class TableInfo<T> {
    private final String className;
    final String tableName;
    private final Class<?> idClass;
    Field aiField = null;
    final Map<String, Column> allColumns = new LinkedHashMap<String, Column>();
    final Map<String, Field> allFields = new LinkedHashMap<String, Field>();
    final List<String> allKeys = new ArrayList<String>();

    private TableInfo(Class<T> clazz) {
        this.className = clazz.getCanonicalName();
        Table table = clazz.getAnnotation(Table.class);
        if (table == null) {
            throw new R2dbcException(String.format("%s: annotation @Table not found.", this.className));
        }
        this.tableName = table.value();
        if (!"TABLE".equals(table.type())) {
            throw new R2dbcException(String.format("%s: [%s] is not a TABLE.", this.className, this.tableName));
        }
        this.idClass = clazz.isAnnotationPresent(IdClass.class) ? clazz.getAnnotation(IdClass.class).value() : null;
        Stream.of(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Column.class)).forEach(field -> {
            Column column = field.getAnnotation(Column.class);
            String key = column.value();
            this.allColumns.put(key, column);
            this.allFields.put(key, (Field)field);
            if (column.primary()) {
                if (column.autoIncrement()) {
                    this.aiField = field;
                }
                this.allKeys.add(key);
            }
        });
    }

    static <T> TableInfo<T> of(T entity) {
        Class<?> clazz = entity.getClass();
        return TableInfo.of(clazz);
    }

    static <T> TableInfo<T> of(Class<T> clazz) {
        return new TableInfo<T>(clazz);
    }

    boolean isKeyNull(T entity) {
        for (String key : this.allKeys) {
            if (Utils.getFieldValue(entity, this.allFields.get(key)) == null) continue;
            return false;
        }
        return true;
    }

    Object aiValueFrom(Number id) {
        Class<?> classType = this.aiField.getType();
        if (classType.equals(Byte.class)) {
            return id.byteValue();
        }
        if (classType.equals(Short.class)) {
            return id.shortValue();
        }
        if (classType.equals(Integer.class)) {
            return id.intValue();
        }
        if (classType.equals(Long.class)) {
            return id.longValue();
        }
        throw new R2dbcException(String.format("%s: field [%s] type %s invalid.", this.className, this.aiField.getName(), classType.getSimpleName()));
    }

    Map<String, Object> getIdValues(@NonNull Object id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (this.idClass != null) {
            if (!id.getClass().equals(this.idClass)) {
                throw new R2dbcException(String.format("%s: invalid primary key class %s. (Should be %s)", this.className, id.getClass().getCanonicalName(), this.idClass.getCanonicalName()));
            }
            HashMap fields = new HashMap();
            Stream.of(this.idClass.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Column.class)).forEach(field -> fields.put(field.getAnnotation(Column.class).value(), field));
            this.allKeys.forEach(key -> {
                Field field = (Field)fields.get(key);
                if (field == null) {
                    throw new R2dbcException(String.format("%s: column [%s] not found in primary key class %s.", this.className, key, this.idClass.getCanonicalName()));
                }
                result.put((String)key, Utils.getFieldValue(id, field));
            });
        } else {
            result.put(this.allKeys.get(0), id);
        }
        return result;
    }

    Object getId(@NonNull Object entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (this.allKeys.isEmpty()) {
            return null;
        }
        if (this.idClass == null) {
            Field field2 = this.allFields.get(this.allKeys.get(0));
            return Utils.getFieldValue(entity, field2);
        }
        HashMap idFields = new HashMap();
        Stream.of(this.idClass.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Column.class)).forEach(field -> idFields.put(field.getAnnotation(Column.class).value(), field));
        try {
            Object idInstance = this.idClass.newInstance();
            this.allKeys.forEach(key -> {
                Field field = this.allFields.get(key);
                Object value = Utils.getFieldValue(entity, field);
                Utils.setFieldValue(idInstance, (Field)idFields.get(key), value);
            });
            return idInstance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new R2dbcException(String.format("%s: failed to invoke newInstance() of primary key class %s.", this.className, this.idClass.getCanonicalName()), e);
        }
    }
}

