/*
 * Decompiled with CFR 0.152.
 */
package net.benpl.r2dbc.support;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.benpl.r2dbc.exception.R2dbcException;
import org.springframework.util.StringUtils;

class Utils {
    Utils() {
    }

    static Object getFieldValue(Object entity, Field field) {
        Method method;
        Class<?> clazz = entity.getClass();
        String className = clazz.getCanonicalName();
        String fieldName = field.getName();
        if (field.isAccessible()) {
            try {
                return field.get(entity);
            }
            catch (IllegalAccessException e) {
                throw new R2dbcException(String.format("%s: failed to get field [%s] value.", className, fieldName), e);
            }
        }
        String methodName = "get" + StringUtils.capitalize((String)fieldName);
        try {
            method = clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new R2dbcException(String.format("%s: getter %s() not found.", className, methodName), e);
        }
        try {
            return method.invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new R2dbcException(String.format("%s: failed to invoke getter %s().", className, methodName), e);
        }
    }

    static void setFieldValue(Object entity, Field field, Object value) {
        Method method;
        Class<?> clazz = entity.getClass();
        String className = clazz.getCanonicalName();
        if (field.isAccessible()) {
            try {
                field.set(entity, value);
            }
            catch (IllegalAccessException e) {
                throw new R2dbcException(String.format("%s: failed to set field [%s] value.", className, field.getName()), e);
            }
        }
        String methodName = "set" + StringUtils.capitalize((String)field.getName());
        Class<?> fieldType = field.getType();
        try {
            method = clazz.getDeclaredMethod(methodName, fieldType);
        }
        catch (NoSuchMethodException e) {
            throw new R2dbcException(String.format("%s: setter %s(%s) not found.", className, methodName, fieldType.getCanonicalName()), e);
        }
        try {
            method.invoke(entity, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new R2dbcException(String.format("%s: failed to invoke setter %s(%s).", className, methodName, fieldType.getCanonicalName()), e);
        }
    }

    static String toCamelCase(String inputString, boolean firstCharacterUppercase) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpperCase = false;
        block3: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case ' ': 
                case '#': 
                case '$': 
                case '&': 
                case '-': 
                case '/': 
                case '@': 
                case '_': {
                    if (sb.length() <= 0) continue block3;
                    nextUpperCase = true;
                    continue block3;
                }
                default: {
                    if (nextUpperCase) {
                        sb.append(Character.toUpperCase(c));
                        nextUpperCase = false;
                        continue block3;
                    }
                    sb.append(Character.toLowerCase(c));
                }
            }
        }
        if (firstCharacterUppercase) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }
}

