/*
 * Decompiled with CFR 0.152.
 */
package net.benpl.r2dbc.support;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.benpl.r2dbc.annotation.Column;
import net.benpl.r2dbc.exception.R2dbcException;
import net.benpl.r2dbc.support.Utils;

class RowMapper<T>
implements BiFunction<Row, RowMetadata, T> {
    private final Class<T> clazz;
    private final String className;
    private final Map<String, Field> allFields = new LinkedHashMap<String, Field>();
    private final Map<String, Field> allColumns = new LinkedHashMap<String, Field>();

    RowMapper(Class<T> clazz) {
        this.clazz = clazz;
        this.className = clazz.getCanonicalName();
        for (Field field : clazz.getDeclaredFields()) {
            this.allFields.put(field.getName(), field);
            Column column = field.getAnnotation(Column.class);
            if (column == null) continue;
            this.allColumns.put(column.value(), field);
        }
    }

    @Override
    public T apply(Row row, RowMetadata metadata) {
        T instance;
        Collection columnNames = metadata.getColumnNames();
        if (columnNames.size() == 1) {
            Class javaType = metadata.getColumnMetadata(0).getJavaType();
            assert (javaType != null);
            if (javaType.equals(this.clazz)) {
                return this.clazz.cast(row.get(0));
            }
        }
        try {
            instance = this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new R2dbcException(String.format("%s: field to create instance.", this.className), e);
        }
        for (String columnName : columnNames) {
            Object value = row.get(columnName);
            Field field = this.allColumns.get(columnName);
            if (field != null) {
                Utils.setFieldValue(instance, field, value);
                continue;
            }
            String fieldName = Utils.toCamelCase(columnName, false);
            field = this.allFields.get(fieldName);
            if (field == null) {
                throw new R2dbcException(String.format("%s: field [%s] not found. (column %s)", this.className, fieldName, columnName));
            }
            Utils.setFieldValue(instance, field, value);
        }
        return instance;
    }
}

