/*
 * Decompiled with CFR 0.152.
 */
package net.benpl.r2dbc.support;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.Pair;
import lombok.NonNull;
import net.benpl.r2dbc.R2dbc;
import net.benpl.r2dbc.annotation.Column;
import net.benpl.r2dbc.exception.R2dbcException;
import net.benpl.r2dbc.support.RowMapper;
import net.benpl.r2dbc.support.TableInfo;
import net.benpl.r2dbc.support.Utils;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.query.Criteria;
import org.springframework.data.r2dbc.query.Update;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class Abstract
implements R2dbc {
    final DatabaseClient databaseClient;

    Abstract(DatabaseClient databaseClient) {
        this.databaseClient = databaseClient;
    }

    @Override
    public <T> Mono<Long> count(Class<T> clazz) {
        TableInfo<T> tableInfo = TableInfo.of(clazz);
        return this.execute0("SELECT COUNT(*) FROM `" + tableInfo.tableName + "`").map(row -> ((Number)Objects.requireNonNull(row.get(0))).longValue()).first();
    }

    @Override
    public <T> Mono<Boolean> existsById(Class<T> clazz, @NonNull Object id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.byId("SELECT EXISTS(SELECT *", ")", clazz, id).map(row -> ((Number)Objects.requireNonNull(row.get(0))).intValue() == 1).first();
    }

    @Override
    public <T> Mono<T> save(@NonNull T entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        TableInfo tableInfo = TableInfo.of(entity);
        if (tableInfo.isKeyNull(entity)) {
            if (tableInfo.aiField != null) {
                return this.insertSpec(tableInfo, entity).map(row -> {
                    Object value = tableInfo.aiValueFrom((Number)row.get(0));
                    Utils.setFieldValue(entity, tableInfo.aiField, value);
                    return entity;
                }).first();
            }
            throw new R2dbcException("Table [" + tableInfo.tableName + "]: failed to save record. (primary key is NULL)");
        }
        return this.updateSpec(tableInfo, entity).fetch().rowsUpdated().map(count -> entity);
    }

    @Override
    public <T> Mono<T> findById(Class<T> clazz, @NonNull Object id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.byId("SELECT *", "", clazz, id).map(new RowMapper<T>(clazz)).first();
    }

    @Override
    public <T> Flux<T> findAll(Class<T> clazz) {
        TableInfo<T> tableInfo = TableInfo.of(clazz);
        String sql = "SELECT * FROM `" + tableInfo.tableName + "`";
        return this.execute0(sql).map(new RowMapper<T>(clazz)).all();
    }

    @Override
    public <T> Mono<Boolean> delete(@NonNull T entity) {
        List params;
        String clauseStr;
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        TableInfo<T> tableInfo = TableInfo.of(entity);
        Collection<String> keys = tableInfo.allKeys;
        Map<String, Field> allFields = tableInfo.allFields;
        if (keys.size() > 0) {
            clauseStr = keys.stream().map(key -> "`" + key + "` = ?").collect(Collectors.joining(" AND "));
            params = keys.stream().map(key -> Utils.getFieldValue(entity, (Field)allFields.get(key))).collect(Collectors.toList());
        } else {
            keys = allFields.keySet();
            clauseStr = keys.stream().map(key -> "`" + key + "` = ?").collect(Collectors.joining(" AND "));
            params = keys.stream().map(key -> Utils.getFieldValue(entity, (Field)allFields.get(key))).collect(Collectors.toList());
        }
        String sql = "DELETE FROM `" + tableInfo.tableName + "` WHERE " + clauseStr;
        return this.execute0(sql, params).fetch().rowsUpdated().map(count -> count == 1);
    }

    @Override
    public <T> Mono<Integer> deleteAll(List<T> entities) {
        List params;
        String clauseStr;
        String valueStr;
        TableInfo<T> tableInfo = TableInfo.of(entities.get(0));
        List<String> allKeys = tableInfo.allKeys;
        Map<String, Field> allFields = tableInfo.allFields;
        if (allKeys.size() == 0) {
            valueStr = allFields.keySet().stream().map(key -> "`" + key + "` = ?").collect(Collectors.joining(" AND ", "(", ")"));
            clauseStr = String.join((CharSequence)" OR ", Collections.nCopies(entities.size(), valueStr));
            params = entities.stream().flatMap(entity -> allFields.keySet().stream().map(key -> Utils.getFieldValue(entity, (Field)allFields.get(key))).collect(Collectors.toList()).stream()).collect(Collectors.toList());
        } else if (allKeys.size() == 1) {
            String key2 = allKeys.get(0);
            clauseStr = key2 + " IN (" + String.join((CharSequence)", ", Collections.nCopies(entities.size(), "?")) + ")";
            params = entities.stream().map(entity -> Utils.getFieldValue(entity, (Field)allFields.get(key2))).collect(Collectors.toList());
        } else {
            valueStr = allKeys.stream().map(key -> "`" + key + "` = ?").collect(Collectors.joining(" AND ", "(", ")"));
            clauseStr = String.join((CharSequence)" OR ", Collections.nCopies(entities.size(), valueStr));
            params = entities.stream().flatMap(entity -> allKeys.stream().map(key -> Utils.getFieldValue(entity, (Field)allFields.get(key))).collect(Collectors.toList()).stream()).collect(Collectors.toList());
        }
        String sql = "DELETE FROM `" + tableInfo.tableName + "` WHERE " + clauseStr;
        return this.execute0(sql, params).fetch().rowsUpdated();
    }

    @Override
    public <T> Mono<Boolean> deleteById(Class<T> clazz, @NonNull Object id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.byId("DELETE", "", clazz, id).fetch().rowsUpdated().map(count -> count == 1);
    }

    @Override
    public <T> Mono<Integer> deleteAll(Class<T> clazz) {
        TableInfo<T> tableInfo = TableInfo.of(clazz);
        String sql = "DELETE FROM `" + tableInfo.tableName + "`";
        return this.execute0(sql).fetch().rowsUpdated();
    }

    @Override
    public <T> Flux<T> select(Class<T> clazz, String sql, Object ... params) {
        return this.execute0(sql, params).map(new RowMapper<T>(clazz)).all();
    }

    @Override
    public Mono<Integer> update(String sql, Object ... params) {
        return this.execute0(sql, params).fetch().rowsUpdated();
    }

    @Override
    public DatabaseClient.GenericExecuteSpec execute(String sql, Object ... params) {
        return this.execute0(sql, params);
    }

    <T> DatabaseClient.GenericExecuteSpec byId(@NonNull String prefix, @NonNull String suffix, Class<T> clazz, @NonNull Object id) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        TableInfo<T> tableInfo = TableInfo.of(clazz);
        Map<String, Object> values = tableInfo.getIdValues(id);
        Set<String> keys = values.keySet();
        String clauseStr = keys.stream().map(key -> "`" + key + "` = ?").collect(Collectors.joining(", "));
        String sql = prefix + " FROM `" + tableInfo.tableName + "` WHERE " + clauseStr + suffix;
        DatabaseClient.GenericExecuteSpec executeSpec = this.databaseClient.execute(sql);
        int i = 0;
        for (String key2 : keys) {
            Object value = values.get(key2);
            executeSpec = value == null ? (DatabaseClient.GenericExecuteSpec)executeSpec.bindNull(i, tableInfo.allFields.get(key2).getType()) : (DatabaseClient.GenericExecuteSpec)executeSpec.bind(i, value);
            ++i;
        }
        return executeSpec;
    }

    DatabaseClient.GenericExecuteSpec execute0(String sql) {
        return this.databaseClient.execute(sql);
    }

    DatabaseClient.GenericExecuteSpec execute0(String sql, Object ... params) {
        List pairs = Stream.of(params).map(param -> new Pair(param.getClass(), param)).collect(Collectors.toList());
        DatabaseClient.GenericExecuteSpec execute = this.databaseClient.execute(sql);
        for (int i = 0; i < pairs.size(); ++i) {
            Pair pair = (Pair)pairs.get(i);
            Object value = pair.getValue();
            execute = value == null ? (DatabaseClient.GenericExecuteSpec)execute.bindNull(i, (Class)pair.getKey()) : (DatabaseClient.GenericExecuteSpec)execute.bind(i, value);
        }
        return execute;
    }

    <T> DatabaseClient.GenericInsertSpec<Map<String, Object>> insertSpec(TableInfo<T> tableInfo, T entity) {
        DatabaseClient.GenericInsertSpec insertSpec = this.databaseClient.insert().into(tableInfo.tableName);
        for (String key : tableInfo.allFields.keySet()) {
            Field field = tableInfo.allFields.get(key);
            Column column = tableInfo.allColumns.get(key);
            Object value = Utils.getFieldValue(entity, field);
            if (value == null) {
                if (column.nullable()) {
                    insertSpec = insertSpec.nullValue(key, field.getType());
                    continue;
                }
                if (!column.noDefault()) continue;
                throw new R2dbcException("Table [" + tableInfo.tableName + "]: " + column.value() + " cannot be set to NULL.");
            }
            insertSpec = insertSpec.value(key, value);
        }
        return insertSpec;
    }

    <T> DatabaseClient.UpdateSpec updateSpec(TableInfo<T> tableInfo, T entity) {
        Object value;
        Update update = null;
        List nonKeys = tableInfo.allFields.keySet().stream().filter(s -> !tableInfo.allKeys.contains(s)).collect(Collectors.toList());
        for (String key : nonKeys) {
            Field field = tableInfo.allFields.get(key);
            value = Utils.getFieldValue(entity, field);
            if (value == null) {
                update = update == null ? Update.update((String)key, null) : update.set(key, null);
                continue;
            }
            update = update == null ? Update.update((String)key, (Object)value) : update.set(key, value);
        }
        Criteria criteria = null;
        for (String key : tableInfo.allKeys) {
            value = Utils.getFieldValue(entity, tableInfo.allFields.get(key));
            criteria = criteria == null ? Criteria.where((String)key).is(value) : criteria.and(key).is(value);
        }
        assert (update != null);
        assert (criteria != null);
        return this.databaseClient.update().table(tableInfo.tableName).using(update).matching(criteria);
    }
}

