/*
 * Decompiled with CFR 0.152.
 */
package net.benpl.r2dbc;

import java.util.List;
import lombok.NonNull;
import net.benpl.r2dbc.Type;
import net.benpl.r2dbc.exception.R2dbcException;
import net.benpl.r2dbc.support.H2;
import net.benpl.r2dbc.support.Mssql;
import net.benpl.r2dbc.support.Mysql;
import net.benpl.r2dbc.support.Postgres;
import org.springframework.data.r2dbc.core.DatabaseClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface R2dbc {
    public <T> Mono<Long> count(Class<T> var1);

    public <T> Mono<Boolean> existsById(Class<T> var1, @NonNull Object var2);

    public <T> Mono<T> save(T var1);

    public <T> Mono<T> findById(Class<T> var1, @NonNull Object var2);

    public <T> Flux<T> findAll(Class<T> var1);

    public <T> Mono<Boolean> delete(@NonNull T var1);

    public <T> Mono<Integer> deleteAll(List<T> var1);

    public <T> Mono<Boolean> deleteById(Class<T> var1, @NonNull Object var2);

    public <T> Mono<Integer> deleteAll(Class<T> var1);

    public <T> Flux<T> select(Class<T> var1, String var2, Object ... var3);

    public Mono<Integer> update(String var1, Object ... var2);

    public DatabaseClient.GenericExecuteSpec execute(String var1, Object ... var2);

    public static R2dbc of(DatabaseClient databaseClient, Type type) {
        switch (type) {
            case MYSQL: {
                return new Mysql(databaseClient);
            }
            case PG: {
                return new Postgres(databaseClient);
            }
            case MSSQL: {
                return new Mssql(databaseClient);
            }
            case H2: {
                return new H2(databaseClient);
            }
        }
        throw new R2dbcException("R2dbc: invalid type " + (Object)((Object)type) + ".");
    }
}

