package net.axay.memoire

import okio.BufferedSink
import okio.BufferedSource
import okio.FileSystem
import okio.Path

class DiskCacheConfig<K, V, P>(
    val fileSystem: FileSystem,
    val directory: Path,
    val keyToFileName: (K) -> String,
    internal val deserializer: BufferedSource.() -> V,
    internal val serializer: BufferedSink.(P) -> Unit,
) {

    fun pathFromKey(key: K): Path {
        return directory.resolve(keyToFileName(key))
    }
}
