package net.axay.memoire

import kotlinx.datetime.Clock
import kotlinx.datetime.Instant
import kotlin.time.Duration

class CacheValidationConfig(
    val expireAfterWrite: Duration?,
    val expireAfterAccess: Duration?,
) {

    fun isValid(lastWrite: Instant, lastAccess: Instant): Boolean {
        val now = Clock.System.now()

        if (expireAfterWrite != null) {
            if (now - lastWrite  > expireAfterWrite)
                return false
        }

        if (expireAfterAccess != null) {
            if (now - lastAccess > expireAfterAccess)
                return false
        }

        return true
    }
}
