/*
 * Decompiled with CFR 0.152.
 */
package net.awired.visuwall.plugin.sonar;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.awired.visuwall.plugin.sonar.Properties;
import net.awired.visuwall.plugin.sonar.Property;

public class SonarVersionExtractor {
    private static final String SONAR_CORE_VERSION_KEY = "sonar.core.version";

    public String propertiesVersion(Properties properties) {
        for (Property property : properties.getProperties()) {
            if (!property.isKey(SONAR_CORE_VERSION_KEY)) continue;
            return property.getValue();
        }
        return "unknown";
    }

    public String welcomePageVersion(URL url) {
        try {
            byte[] byteArray = ByteStreams.toByteArray((InputStream)url.openStream());
            String htmlContent = new String(byteArray);
            Pattern p = Pattern.compile(".* - v\\.([0-9]\\.[0-9]*.[0-9]*) - .*");
            Matcher m = p.matcher(htmlContent);
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (IOException iOException) {
            return "unknown";
        }
        return "unknown";
    }
}

