/*
 * Decompiled with CFR 0.152.
 */
package net.awired.visuwall.plugin.sonar;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import net.awired.clients.common.GenericSoftwareClient;
import net.awired.visuwall.api.domain.SoftwareId;
import net.awired.visuwall.api.exception.ConnectionException;
import net.awired.visuwall.api.exception.SoftwareNotFoundException;
import net.awired.visuwall.api.plugin.VisuwallPlugin;
import net.awired.visuwall.plugin.sonar.Properties;
import net.awired.visuwall.plugin.sonar.SonarCompatibleVersionChecker;
import net.awired.visuwall.plugin.sonar.SonarConnection;
import net.awired.visuwall.plugin.sonar.SonarConnectionFactory;
import net.awired.visuwall.plugin.sonar.SonarDetector;
import net.awired.visuwall.plugin.sonar.SonarVersionExtractor;

public class SonarPlugin
implements VisuwallPlugin<SonarConnection> {
    private static final double SONAR_MINIMUM_COMPATIBLE_VERSION = 2.4;
    static final String SONAR_CORE_VERSION_KEY = "sonar.core.version";
    private GenericSoftwareClient client;
    private SonarConnectionFactory sonarConnectionFactory;
    private SonarDetector sonarDetector = new SonarDetector();
    private SonarVersionExtractor sonarVersionExtractor = new SonarVersionExtractor();
    private SonarCompatibleVersionChecker sonarCompatibleVersionChecker = new SonarCompatibleVersionChecker(2.4);

    public SonarPlugin() {
        this.client = new GenericSoftwareClient();
        this.sonarConnectionFactory = new SonarConnectionFactory();
    }

    public SonarConnection getConnection(URL url, Map<String, String> properties) throws ConnectionException {
        Preconditions.checkNotNull((Object)url, (Object)"url is mandatory");
        String login = properties.get("login");
        String password = properties.get("password");
        return this.sonarConnectionFactory.create(url.toString(), login, password);
    }

    public Class<SonarConnection> getConnectionClass() {
        return SonarConnection.class;
    }

    public String getName() {
        return "Sonar plugin";
    }

    public float getVersion() {
        return 1.0f;
    }

    public SoftwareId getSoftwareId(URL url) throws SoftwareNotFoundException {
        Preconditions.checkNotNull((Object)url, (Object)"url is mandatory");
        if (this.sonarDetector.isSonarPropertiesPage(url)) {
            return this.createSoftwareIdFromProperties(url);
        }
        if (this.sonarDetector.isSonarWelcomePage(url)) {
            return this.createSoftwareIdFromWelcomePage(url);
        }
        throw new SoftwareNotFoundException("Url " + url.toString() + " is not compatible with Sonar");
    }

    private SoftwareId createSoftwareIdFromWelcomePage(URL url) {
        String version = this.sonarVersionExtractor.welcomePageVersion(url);
        return this.createSoftwareId(version);
    }

    private SoftwareId createSoftwareIdFromProperties(URL url) throws SoftwareNotFoundException {
        String propertiesUrl = this.sonarDetector.buildPropertiesUrl(url);
        Properties properties = (Properties)this.client.existingResource(propertiesUrl, Properties.class, MediaType.APPLICATION_XML_TYPE);
        String version = this.sonarVersionExtractor.propertiesVersion(properties);
        return this.createSoftwareId(version);
    }

    private SoftwareId createSoftwareId(String version) {
        SoftwareId softwareId = new SoftwareId();
        softwareId.setName("Sonar");
        boolean versionIsCompatible = this.sonarCompatibleVersionChecker.versionIsCompatible(version);
        softwareId.setCompatible(versionIsCompatible);
        softwareId.setVersion(version);
        if (!versionIsCompatible) {
            softwareId.setWarnings("Sonar version " + version + " is not compatible with Visuwall. Please use a version >= " + 2.4);
        }
        return softwareId;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("version", (Object)Float.valueOf(this.getVersion())).toString();
    }

    public Map<String, String> getPropertiesWithDefaultValue() {
        return new HashMap<String, String>();
    }
}

