/*
 * Decompiled with CFR 0.152.
 */
package net.awired.visuwall.plugin.sonar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.awired.clients.sonar.Sonar;
import net.awired.clients.sonar.domain.SonarQualityMetric;
import net.awired.clients.sonar.exception.SonarMeasureNotFoundException;
import net.awired.clients.sonar.exception.SonarMetricsNotFoundException;
import net.awired.clients.sonar.exception.SonarProjectNotFoundException;
import net.awired.clients.sonar.exception.SonarProjectsNotFoundException;
import net.awired.clients.sonar.exception.SonarResourceNotFoundException;
import net.awired.clients.sonar.resource.Project;
import net.awired.visuwall.api.domain.BuildState;
import net.awired.visuwall.api.domain.BuildTime;
import net.awired.visuwall.api.domain.Commiter;
import net.awired.visuwall.api.domain.ProjectKey;
import net.awired.visuwall.api.domain.SoftwareProjectId;
import net.awired.visuwall.api.domain.TestResult;
import net.awired.visuwall.api.domain.quality.QualityMeasure;
import net.awired.visuwall.api.domain.quality.QualityMetric;
import net.awired.visuwall.api.domain.quality.QualityResult;
import net.awired.visuwall.api.exception.BuildIdNotFoundException;
import net.awired.visuwall.api.exception.BuildNotFoundException;
import net.awired.visuwall.api.exception.MavenIdNotFoundException;
import net.awired.visuwall.api.exception.ProjectNotFoundException;
import net.awired.visuwall.api.plugin.capability.MetricCapability;
import net.awired.visuwall.api.plugin.capability.TestCapability;
import net.awired.visuwall.plugin.sonar.Chrono;
import net.awired.visuwall.plugin.sonar.QualityMeasures;
import net.awired.visuwall.plugin.sonar.SonarQualityMeasure;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Resource;

public class SonarConnection
implements MetricCapability,
TestCapability {
    private static final Logger LOG;
    private final UUID id = UUID.randomUUID();
    @VisibleForTesting
    Sonar sonarClient;
    private Map<String, QualityMetric> metricsMap;
    private String[] metricKeys = new String[0];
    private boolean connected;
    private String url;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;

    static {
        SonarConnection.ajc$preClinit();
        LOG = LoggerFactory.getLogger(SonarConnection.class);
    }

    public void connect(String url, String login, String password) {
        String string = url;
        String string2 = login;
        String string3 = password;
        SonarConnection.connect_aroundBody1$advice(this, string, string2, string3, Chrono.aspectOf(), null, ajc$tjp_0);
    }

    public Map<String, List<QualityMetric>> getMetricsByCategory() {
        return (Map)SonarConnection.getMetricsByCategory_aroundBody3$advice(this, Chrono.aspectOf(), null, ajc$tjp_1);
    }

    public Map<SoftwareProjectId, String> listSoftwareProjectIds() {
        return (Map)SonarConnection.listSoftwareProjectIds_aroundBody5$advice(this, Chrono.aspectOf(), null, ajc$tjp_2);
    }

    public void close() {
        SonarConnection.close_aroundBody7$advice(this, Chrono.aspectOf(), null, ajc$tjp_3);
    }

    public boolean equals(Object o) {
        Object object = o;
        return Conversions.booleanValue((Object)SonarConnection.equals_aroundBody9$advice(this, object, Chrono.aspectOf(), null, ajc$tjp_4));
    }

    public int hashCode() {
        return Conversions.intValue((Object)SonarConnection.hashCode_aroundBody11$advice(this, Chrono.aspectOf(), null, ajc$tjp_5));
    }

    public String getDescription(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        return (String)SonarConnection.getDescription_aroundBody13$advice(this, softwareProjectId2, Chrono.aspectOf(), null, ajc$tjp_6);
    }

    public SoftwareProjectId identify(ProjectKey projectKey) throws ProjectNotFoundException {
        ProjectKey projectKey2 = projectKey;
        return (SoftwareProjectId)SonarConnection.identify_aroundBody15$advice(this, projectKey2, Chrono.aspectOf(), null, ajc$tjp_7);
    }

    public TestResult analyzeUnitTests(SoftwareProjectId projectId) {
        SoftwareProjectId softwareProjectId = projectId;
        return (TestResult)SonarConnection.analyzeUnitTests_aroundBody17$advice(this, softwareProjectId, Chrono.aspectOf(), null, ajc$tjp_8);
    }

    public TestResult analyzeIntegrationTests(SoftwareProjectId projectId) {
        SoftwareProjectId softwareProjectId = projectId;
        return (TestResult)SonarConnection.analyzeIntegrationTests_aroundBody19$advice(this, softwareProjectId, Chrono.aspectOf(), null, ajc$tjp_9);
    }

    public QualityResult analyzeQuality(SoftwareProjectId projectId, String ... metrics) {
        SoftwareProjectId softwareProjectId = projectId;
        String[] stringArray = metrics;
        return (QualityResult)SonarConnection.analyzeQuality_aroundBody21$advice(this, softwareProjectId, stringArray, Chrono.aspectOf(), null, ajc$tjp_10);
    }

    private void addQualityMeasure(QualityResult qualityResult, String artifactId, String key) {
        block3: {
            try {
                Measure measure = this.sonarClient.findMeasure(artifactId, key);
                if (measure != null && measure.getValue() != null) {
                    SonarQualityMeasure qualityMeasure = QualityMeasures.asQualityMeasure(measure, key);
                    qualityMeasure.setName(this.metricsMap.get(key).getName());
                    qualityResult.add(key, this.asQualityMeasure(qualityMeasure));
                }
            }
            catch (SonarMeasureNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug(e.getMessage());
            }
        }
    }

    private QualityMeasure asQualityMeasure(SonarQualityMeasure sonarQualityMeasure) {
        QualityMeasure qualityMeasure = new QualityMeasure();
        qualityMeasure.setFormattedValue(sonarQualityMeasure.getFormattedValue());
        qualityMeasure.setKey(sonarQualityMeasure.getKey());
        qualityMeasure.setName(sonarQualityMeasure.getName());
        qualityMeasure.setValue(sonarQualityMeasure.getValue());
        return qualityMeasure;
    }

    public String getMavenId(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException, MavenIdNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        return (String)SonarConnection.getMavenId_aroundBody23$advice(this, softwareProjectId2, Chrono.aspectOf(), null, ajc$tjp_11);
    }

    public String getName(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        return (String)SonarConnection.getName_aroundBody25$advice(this, softwareProjectId2, Chrono.aspectOf(), null, ajc$tjp_12);
    }

    public boolean isClosed() {
        return Conversions.booleanValue((Object)SonarConnection.isClosed_aroundBody27$advice(this, Chrono.aspectOf(), null, ajc$tjp_13));
    }

    public boolean isProjectDisabled(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        return Conversions.booleanValue((Object)SonarConnection.isProjectDisabled_aroundBody29$advice(this, softwareProjectId2, Chrono.aspectOf(), null, ajc$tjp_14));
    }

    private TestResult createUnitTestAnalysis(String artifactId) {
        TestResult unitTestResult;
        block2: {
            unitTestResult = new TestResult();
            try {
                Double coverage = this.sonarClient.findMeasure(artifactId, "coverage").getValue();
                Double failures = this.sonarClient.findMeasure(artifactId, "test_failures").getValue();
                Double errors = this.sonarClient.findMeasure(artifactId, "test_errors").getValue();
                Double passTests = this.sonarClient.findMeasure(artifactId, "tests").getValue();
                int skipCount = this.sonarClient.findMeasure(artifactId, "skipped_tests").getIntValue();
                int failCount = failures.intValue() + errors.intValue();
                int passCount = passTests.intValue() - failCount;
                unitTestResult.setCoverage(coverage.doubleValue());
                unitTestResult.setFailCount(failCount);
                unitTestResult.setSkipCount(skipCount);
                unitTestResult.setPassCount(passCount);
            }
            catch (SonarMeasureNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Unit tests informations are not available for project with artifactId : " + artifactId + ", cause " + e.getMessage());
            }
        }
        return unitTestResult;
    }

    private void initializeMetrics() {
        block2: {
            try {
                this.metricsMap = this.asMetrics(this.sonarClient.findMetrics());
                Set<String> metricKeysSet = this.metricsMap.keySet();
                int countMetricKeys = metricKeysSet.size();
                this.metricKeys = metricKeysSet.toArray(new String[countMetricKeys]);
            }
            catch (SonarMetricsNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Can't initialize metrics", (Throwable)e);
            }
        }
    }

    private Map<String, QualityMetric> asMetrics(Map<String, SonarQualityMetric> sonarMetrics) {
        HashMap<String, QualityMetric> metrics = new HashMap<String, QualityMetric>();
        for (Map.Entry<String, SonarQualityMetric> metric : sonarMetrics.entrySet()) {
            String key = metric.getKey();
            SonarQualityMetric value = metric.getValue();
            QualityMetric qualityMetric = this.asQualityMetric(value);
            metrics.put(key, qualityMetric);
        }
        return metrics;
    }

    private QualityMetric asQualityMetric(SonarQualityMetric sonarQualityMetric) {
        QualityMetric qualityMetric = new QualityMetric();
        qualityMetric.setDescription(sonarQualityMetric.getDescription());
        qualityMetric.setDirection(sonarQualityMetric.getDirection());
        qualityMetric.setDomain(sonarQualityMetric.getDomain());
        qualityMetric.setHidden(sonarQualityMetric.getHidden());
        qualityMetric.setKey(sonarQualityMetric.getKey());
        qualityMetric.setName(sonarQualityMetric.getName());
        qualityMetric.setQualitative(sonarQualityMetric.getQualitative());
        qualityMetric.setUserManaged(sonarQualityMetric.getUserManaged());
        qualityMetric.setValTyp(sonarQualityMetric.getValTyp());
        return qualityMetric;
    }

    public BuildTime getBuildTime(SoftwareProjectId softwareProjectId, Integer buildId) throws BuildNotFoundException, ProjectNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        Integer n = buildId;
        return (BuildTime)SonarConnection.getBuildTime_aroundBody31$advice(this, softwareProjectId2, n, Chrono.aspectOf(), null, ajc$tjp_15);
    }

    @Deprecated
    public List<Integer> getBuildIds(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        return (List)SonarConnection.getBuildIds_aroundBody33$advice(this, softwareProjectId2, Chrono.aspectOf(), null, ajc$tjp_16);
    }

    @Deprecated
    public BuildState getBuildState(SoftwareProjectId softwareProjectId, Integer buildId) throws ProjectNotFoundException, BuildNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        Integer n = buildId;
        return (BuildState)SonarConnection.getBuildState_aroundBody35$advice(this, softwareProjectId2, n, Chrono.aspectOf(), null, ajc$tjp_17);
    }

    @Deprecated
    public Date getEstimatedFinishTime(SoftwareProjectId softwareProjectId, Integer buildId) throws ProjectNotFoundException, BuildNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        Integer n = buildId;
        return (Date)SonarConnection.getEstimatedFinishTime_aroundBody37$advice(this, softwareProjectId2, n, Chrono.aspectOf(), null, ajc$tjp_18);
    }

    @Deprecated
    public boolean isBuilding(SoftwareProjectId softwareProjectId, Integer buildId) throws ProjectNotFoundException, BuildNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        Integer n = buildId;
        return Conversions.booleanValue((Object)SonarConnection.isBuilding_aroundBody39$advice(this, softwareProjectId2, n, Chrono.aspectOf(), null, ajc$tjp_19));
    }

    @Deprecated
    public int getLastBuildId(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException, BuildIdNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        return Conversions.intValue((Object)SonarConnection.getLastBuildId_aroundBody41$advice(this, softwareProjectId2, Chrono.aspectOf(), null, ajc$tjp_20));
    }

    @Deprecated
    public List<Commiter> getBuildCommiters(SoftwareProjectId softwareProjectId, Integer buildId) throws BuildNotFoundException, ProjectNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        Integer n = buildId;
        return (List)SonarConnection.getBuildCommiters_aroundBody43$advice(this, softwareProjectId2, n, Chrono.aspectOf(), null, ajc$tjp_21);
    }

    private void checkBuildId(int buildId) {
        Preconditions.checkNotNull((Object)buildId, (Object)"buildId is mandatory");
    }

    private void checkSoftwareProjectId(SoftwareProjectId softwareProjectId) {
        Preconditions.checkNotNull((Object)softwareProjectId, (Object)"softwareProjectId is mandatory");
    }

    private void checkConnected() {
        Preconditions.checkState((boolean)this.connected, (Object)"You must connect your plugin");
    }

    private static final /* synthetic */ void connect_aroundBody0(SonarConnection ajc$this, String url, String login, String password) {
        ajc$this.url = url;
        if (LOG.isInfoEnabled()) {
            LOG.info("Initialize sonar with url " + url);
        }
        if (ajc$this.sonarClient == null) {
            ajc$this.sonarClient = new Sonar(url, login, password);
        }
        ajc$this.connected = true;
    }

    private static final /* synthetic */ Object connect_aroundBody1$advice(SonarConnection ajc$this, String url, String login, String password, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            SonarConnection.connect_aroundBody0(ajc$this, url, login, password);
            Object var10_9 = null;
            return var10_9;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ Map getMetricsByCategory_aroundBody2(SonarConnection ajc$this) {
        ajc$this.checkConnected();
        if (ajc$this.metricsMap == null) {
            ajc$this.initializeMetrics();
        }
        HashMap<String, ArrayList<QualityMetric>> metricsByDomain = new HashMap<String, ArrayList<QualityMetric>>();
        for (QualityMetric metricValue : ajc$this.metricsMap.values()) {
            String domain = metricValue.getDomain();
            ArrayList<QualityMetric> domainMetrics = (ArrayList<QualityMetric>)metricsByDomain.get(domain);
            if (domainMetrics == null) {
                domainMetrics = new ArrayList<QualityMetric>();
                metricsByDomain.put(domain, domainMetrics);
            }
            domainMetrics.add(metricValue);
        }
        return metricsByDomain;
    }

    private static final /* synthetic */ Object getMetricsByCategory_aroundBody3$advice(SonarConnection ajc$this, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Map map = SonarConnection.getMetricsByCategory_aroundBody2(ajc$this);
            return map;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ Map listSoftwareProjectIds_aroundBody4(SonarConnection ajc$this) {
        ajc$this.checkConnected();
        HashMap<SoftwareProjectId, String> projects = new HashMap<SoftwareProjectId, String>();
        try {
            List names = ajc$this.sonarClient.findProjects().getProjects();
            for (Project project : names) {
                String key = project.getKey();
                projects.put(new SoftwareProjectId(key), project.getName());
            }
        }
        catch (SonarProjectsNotFoundException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        return projects;
    }

    private static final /* synthetic */ Object listSoftwareProjectIds_aroundBody5$advice(SonarConnection ajc$this, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Map map = SonarConnection.listSoftwareProjectIds_aroundBody4(ajc$this);
            return map;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ Object close_aroundBody7$advice(SonarConnection ajc$this, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            ajc$this.connected = false;
            Object var7_6 = null;
            return var7_6;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ boolean equals_aroundBody8(SonarConnection ajc$this, Object o) {
        if (o instanceof SonarConnection) {
            SonarConnection s = (SonarConnection)o;
            return ajc$this.id.equals(s.id);
        }
        return false;
    }

    private static final /* synthetic */ Object equals_aroundBody9$advice(SonarConnection ajc$this, Object o, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = Conversions.booleanObject((boolean)SonarConnection.equals_aroundBody8(ajc$this, o));
            return object;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ int hashCode_aroundBody10(SonarConnection ajc$this) {
        return Objects.hashCode((Object[])new Object[]{ajc$this.id});
    }

    private static final /* synthetic */ Object hashCode_aroundBody11$advice(SonarConnection ajc$this, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = Conversions.intObject((int)SonarConnection.hashCode_aroundBody10(ajc$this));
            return object;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ String getDescription_aroundBody12(SonarConnection ajc$this, SoftwareProjectId softwareProjectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        try {
            String artifactId = softwareProjectId.getProjectId();
            Resource resource = ajc$this.sonarClient.findResource(artifactId);
            return resource.getName(true);
        }
        catch (SonarResourceNotFoundException e) {
            throw new ProjectNotFoundException("Can't get description of software project id: " + softwareProjectId, (Throwable)e);
        }
    }

    private static final /* synthetic */ Object getDescription_aroundBody13$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = SonarConnection.getDescription_aroundBody12(ajc$this, softwareProjectId);
            return string;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ SoftwareProjectId identify_aroundBody14(SonarConnection ajc$this, ProjectKey projectKey) {
        ajc$this.checkConnected();
        Preconditions.checkNotNull((Object)projectKey, (Object)"projectKey is mandatory");
        try {
            String mavenId = projectKey.getMavenId();
            if (mavenId != null) {
                Resource resource = ajc$this.sonarClient.findResource(mavenId);
                SoftwareProjectId softwareProjectId = new SoftwareProjectId(resource.getKey());
                return softwareProjectId;
            }
        }
        catch (SonarResourceNotFoundException e) {
            throw new ProjectNotFoundException("Can't identify project key: " + projectKey, (Throwable)e);
        }
        throw new ProjectNotFoundException("Can't identify project key, there is not enough informations: " + projectKey);
    }

    private static final /* synthetic */ Object identify_aroundBody15$advice(SonarConnection ajc$this, ProjectKey projectKey, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            SoftwareProjectId softwareProjectId = SonarConnection.identify_aroundBody14(ajc$this, projectKey);
            return softwareProjectId;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ TestResult analyzeUnitTests_aroundBody16(SonarConnection ajc$this, SoftwareProjectId projectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(projectId);
        TestResult unitTestResult = new TestResult();
        String artifactId = projectId.getProjectId();
        if (Strings.isNullOrEmpty((String)artifactId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("can't analyze project " + projectId + " without artifactId. Is it a maven project ?");
            }
        } else {
            unitTestResult = ajc$this.createUnitTestAnalysis(artifactId);
        }
        return unitTestResult;
    }

    private static final /* synthetic */ Object analyzeUnitTests_aroundBody17$advice(SonarConnection ajc$this, SoftwareProjectId projectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            TestResult testResult = SonarConnection.analyzeUnitTests_aroundBody16(ajc$this, projectId);
            return testResult;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ TestResult analyzeIntegrationTests_aroundBody18(SonarConnection ajc$this, SoftwareProjectId projectId) {
        TestResult integrationTestResult;
        block6: {
            ajc$this.checkConnected();
            ajc$this.checkSoftwareProjectId(projectId);
            integrationTestResult = new TestResult();
            try {
                String artifactId = projectId.getProjectId();
                if (Strings.isNullOrEmpty((String)artifactId)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("can't analyze project " + projectId + " without artifactId. Is it a maven project ?");
                    }
                } else {
                    Measure itCoverageMeasure = ajc$this.sonarClient.findMeasure(artifactId, "it_coverage");
                    if (itCoverageMeasure != null) {
                        Double itCoverage = itCoverageMeasure.getValue();
                        integrationTestResult.setCoverage(itCoverage.doubleValue());
                    }
                }
            }
            catch (SonarMeasureNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("Integration tests informations are not available for project " + projectId + ", cause " + e.getMessage());
            }
        }
        return integrationTestResult;
    }

    private static final /* synthetic */ Object analyzeIntegrationTests_aroundBody19$advice(SonarConnection ajc$this, SoftwareProjectId projectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            TestResult testResult = SonarConnection.analyzeIntegrationTests_aroundBody18(ajc$this, projectId);
            return testResult;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ QualityResult analyzeQuality_aroundBody20(SonarConnection ajc$this, SoftwareProjectId projectId, String[] metrics) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(projectId);
        if (ajc$this.metricsMap == null) {
            ajc$this.initializeMetrics();
        }
        if (metrics.length == 0) {
            metrics = ajc$this.metricKeys;
        }
        QualityResult qualityResult = new QualityResult();
        String artifactId = projectId.getProjectId();
        if (!Strings.isNullOrEmpty((String)artifactId)) {
            String[] stringArray = metrics;
            int n = metrics.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                ajc$this.addQualityMeasure(qualityResult, artifactId, key);
                ++n2;
            }
        }
        return qualityResult;
    }

    private static final /* synthetic */ Object analyzeQuality_aroundBody21$advice(SonarConnection ajc$this, SoftwareProjectId projectId, String[] metrics, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            QualityResult qualityResult = SonarConnection.analyzeQuality_aroundBody20(ajc$this, projectId, metrics);
            return qualityResult;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ String getMavenId_aroundBody22(SonarConnection ajc$this, SoftwareProjectId softwareProjectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        try {
            String artifactId = softwareProjectId.getProjectId();
            Resource resource = ajc$this.sonarClient.findResource(artifactId);
            return resource.getKey();
        }
        catch (SonarResourceNotFoundException e) {
            throw new MavenIdNotFoundException("Can't get maven id of software project id: " + softwareProjectId, (Throwable)e);
        }
    }

    private static final /* synthetic */ Object getMavenId_aroundBody23$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = SonarConnection.getMavenId_aroundBody22(ajc$this, softwareProjectId);
            return string;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ String getName_aroundBody24(SonarConnection ajc$this, SoftwareProjectId softwareProjectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        try {
            String artifactId = softwareProjectId.getProjectId();
            Resource resource = ajc$this.sonarClient.findResource(artifactId);
            return resource.getName();
        }
        catch (SonarResourceNotFoundException e) {
            throw new ProjectNotFoundException("Can't get name of software project id: " + softwareProjectId, (Throwable)e);
        }
    }

    private static final /* synthetic */ Object getName_aroundBody25$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = SonarConnection.getName_aroundBody24(ajc$this, softwareProjectId);
            return string;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ boolean isClosed_aroundBody26(SonarConnection ajc$this) {
        return !ajc$this.connected;
    }

    private static final /* synthetic */ Object isClosed_aroundBody27$advice(SonarConnection ajc$this, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = Conversions.booleanObject((boolean)SonarConnection.isClosed_aroundBody26(ajc$this));
            return object;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ boolean isProjectDisabled_aroundBody28(SonarConnection ajc$this, SoftwareProjectId softwareProjectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        try {
            String artifactId = softwareProjectId.getProjectId();
            ajc$this.sonarClient.findProject(artifactId);
        }
        catch (SonarProjectNotFoundException sonarProjectNotFoundException) {
            throw new ProjectNotFoundException("Can't find if project is disabled, softwareProjectId:" + softwareProjectId + ", url: " + ajc$this.url);
        }
        return false;
    }

    private static final /* synthetic */ Object isProjectDisabled_aroundBody29$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = Conversions.booleanObject((boolean)SonarConnection.isProjectDisabled_aroundBody28(ajc$this, softwareProjectId));
            return object;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ BuildTime getBuildTime_aroundBody30(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        BuildTime buildTime = new BuildTime();
        buildTime.setDuration(1L);
        buildTime.setStartTime(new Date());
        return buildTime;
    }

    private static final /* synthetic */ Object getBuildTime_aroundBody31$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            BuildTime buildTime = SonarConnection.getBuildTime_aroundBody30(ajc$this, softwareProjectId, buildId);
            return buildTime;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ List getBuildIds_aroundBody32(SonarConnection ajc$this, SoftwareProjectId softwareProjectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        return Arrays.asList(1);
    }

    private static final /* synthetic */ Object getBuildIds_aroundBody33$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            List list = SonarConnection.getBuildIds_aroundBody32(ajc$this, softwareProjectId);
            return list;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ BuildState getBuildState_aroundBody34(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        return BuildState.SUCCESS;
    }

    private static final /* synthetic */ Object getBuildState_aroundBody35$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            BuildState buildState = SonarConnection.getBuildState_aroundBody34(ajc$this, softwareProjectId, buildId);
            return buildState;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ Date getEstimatedFinishTime_aroundBody36(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        return new Date();
    }

    private static final /* synthetic */ Object getEstimatedFinishTime_aroundBody37$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Date date = SonarConnection.getEstimatedFinishTime_aroundBody36(ajc$this, softwareProjectId, buildId);
            return date;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ boolean isBuilding_aroundBody38(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        return false;
    }

    private static final /* synthetic */ Object isBuilding_aroundBody39$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = Conversions.booleanObject((boolean)SonarConnection.isBuilding_aroundBody38(ajc$this, softwareProjectId, buildId));
            return object;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ int getLastBuildId_aroundBody40(SonarConnection ajc$this, SoftwareProjectId softwareProjectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        return 1;
    }

    private static final /* synthetic */ Object getLastBuildId_aroundBody41$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = Conversions.intObject((int)SonarConnection.getLastBuildId_aroundBody40(ajc$this, softwareProjectId));
            return object;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ List getBuildCommiters_aroundBody42(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        ajc$this.checkBuildId(buildId);
        return new ArrayList();
    }

    private static final /* synthetic */ Object getBuildCommiters_aroundBody43$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            List list = SonarConnection.getBuildCommiters_aroundBody42(ajc$this, softwareProjectId, buildId);
            return list;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SonarConnection.java", SonarConnection.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "connect", "net.awired.visuwall.plugin.sonar.SonarConnection", "java.lang.String:java.lang.String:java.lang.String", "url:login:password", "", "void"), 82);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMetricsByCategory", "net.awired.visuwall.plugin.sonar.SonarConnection", "", "", "", "java.util.Map"), 94);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "analyzeQuality", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId:[Ljava.lang.String;", "projectId:metrics", "", "net.awired.visuwall.api.domain.quality.QualityResult"), 222);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMavenId", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "softwareProjectId", "net.awired.visuwall.api.exception.ProjectNotFoundException:net.awired.visuwall.api.exception.MavenIdNotFoundException", "java.lang.String"), 266);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getName", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "softwareProjectId", "net.awired.visuwall.api.exception.ProjectNotFoundException", "java.lang.String"), 280);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isClosed", "net.awired.visuwall.plugin.sonar.SonarConnection", "", "", "", "boolean"), 293);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isProjectDisabled", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "softwareProjectId", "net.awired.visuwall.api.exception.ProjectNotFoundException", "boolean"), 298);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBuildTime", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId:java.lang.Integer", "softwareProjectId:buildId", "net.awired.visuwall.api.exception.BuildNotFoundException:net.awired.visuwall.api.exception.ProjectNotFoundException", "net.awired.visuwall.api.domain.BuildTime"), 374);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBuildIds", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "softwareProjectId", "net.awired.visuwall.api.exception.ProjectNotFoundException", "java.util.List"), 386);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBuildState", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId:java.lang.Integer", "softwareProjectId:buildId", "net.awired.visuwall.api.exception.ProjectNotFoundException:net.awired.visuwall.api.exception.BuildNotFoundException", "net.awired.visuwall.api.domain.BuildState"), 394);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEstimatedFinishTime", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId:java.lang.Integer", "softwareProjectId:buildId", "net.awired.visuwall.api.exception.ProjectNotFoundException:net.awired.visuwall.api.exception.BuildNotFoundException", "java.util.Date"), 403);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isBuilding", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId:java.lang.Integer", "softwareProjectId:buildId", "net.awired.visuwall.api.exception.ProjectNotFoundException:net.awired.visuwall.api.exception.BuildNotFoundException", "boolean"), 412);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listSoftwareProjectIds", "net.awired.visuwall.plugin.sonar.SonarConnection", "", "", "", "java.util.Map"), 113);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLastBuildId", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "softwareProjectId", "net.awired.visuwall.api.exception.ProjectNotFoundException:net.awired.visuwall.api.exception.BuildIdNotFoundException", "int"), 421);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBuildCommiters", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId:java.lang.Integer", "softwareProjectId:buildId", "net.awired.visuwall.api.exception.BuildNotFoundException:net.awired.visuwall.api.exception.ProjectNotFoundException", "java.util.List"), 430);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "net.awired.visuwall.plugin.sonar.SonarConnection", "", "", "", "void"), 129);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "net.awired.visuwall.plugin.sonar.SonarConnection", "java.lang.Object", "o", "", "boolean"), 134);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "net.awired.visuwall.plugin.sonar.SonarConnection", "", "", "", "int"), 143);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDescription", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "softwareProjectId", "net.awired.visuwall.api.exception.ProjectNotFoundException", "java.lang.String"), 148);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "identify", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.ProjectKey", "projectKey", "net.awired.visuwall.api.exception.ProjectNotFoundException", "net.awired.visuwall.api.domain.SoftwareProjectId"), 161);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "analyzeUnitTests", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "projectId", "", "net.awired.visuwall.api.domain.TestResult"), 179);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "analyzeIntegrationTests", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "projectId", "", "net.awired.visuwall.api.domain.TestResult"), 195);
    }
}

