/*
 * Decompiled with CFR 0.152.
 */
package net.awired.visuwall.plugin.sonar;

public class SonarCompatibleVersionChecker {
    private int minimumCompatibleVersionIntPart;
    private int minimumCompatibleVersionDecimalPart;

    public SonarCompatibleVersionChecker(Double sonarMinimumCompatibleVersion) {
        this.minimumCompatibleVersionIntPart = sonarMinimumCompatibleVersion.intValue();
        this.minimumCompatibleVersionDecimalPart = this.getDecimalPart(sonarMinimumCompatibleVersion);
    }

    public boolean versionIsCompatible(String version) {
        try {
            double versionAsFloat = Double.valueOf(version);
            return this.versionIsCompatible(versionAsFloat);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean versionIsCompatible(Double version) {
        int decimalPart;
        int intPart = version.intValue();
        if (this.minimumCompatibleVersionIntPart < intPart) {
            return true;
        }
        return this.minimumCompatibleVersionIntPart < intPart || this.minimumCompatibleVersionDecimalPart <= (decimalPart = this.getDecimalPart(version).intValue());
    }

    private Integer getDecimalPart(Double value) {
        if (!value.toString().contains(".")) {
            return 0;
        }
        return Integer.valueOf(value.toString().split("\\.")[1]);
    }
}

