/*
 * Decompiled with CFR 0.152.
 */
package net.awired.visuwall.plugin.sonar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URL;
import javax.ws.rs.core.MediaType;
import net.awired.visuwall.api.domain.SoftwareId;
import net.awired.visuwall.api.exception.ConnectionException;
import net.awired.visuwall.api.exception.IncompatibleSoftwareException;
import net.awired.visuwall.api.plugin.VisuwallPlugin;
import net.awired.visuwall.common.client.GenericSoftwareClient;
import net.awired.visuwall.common.client.ResourceNotFoundException;
import net.awired.visuwall.plugin.sonar.Properties;
import net.awired.visuwall.plugin.sonar.Property;
import net.awired.visuwall.plugin.sonar.SonarConnection;
import net.awired.visuwall.plugin.sonar.SonarConnectionFactory;
import net.awired.visuwall.plugin.sonar.SonarVersionExtractor;

public class SonarPlugin
implements VisuwallPlugin<SonarConnection> {
    static final String SONAR_CORE_VERSION_KEY = "sonar.core.version";
    @VisibleForTesting
    GenericSoftwareClient client = new GenericSoftwareClient();
    @VisibleForTesting
    SonarConnectionFactory sonarConnectionFactory = new SonarConnectionFactory();

    public SonarConnection getConnection(String url, java.util.Properties info) throws ConnectionException {
        Preconditions.checkNotNull((Object)url, (Object)"url is mandatory");
        SonarConnection sonarConnection = this.sonarConnectionFactory.create(url);
        return sonarConnection;
    }

    public Class<SonarConnection> getConnectionClass() {
        return SonarConnection.class;
    }

    public String getName() {
        return "Sonar plugin";
    }

    public float getVersion() {
        return 1.0f;
    }

    public SoftwareId getSoftwareId(URL url) throws IncompatibleSoftwareException {
        Preconditions.checkNotNull((Object)url, (Object)"url is mandatory");
        try {
            String propertiesUrl = String.valueOf(url.toString()) + "/api/properties/sonar.core.version";
            Properties properties = (Properties)this.client.resource(propertiesUrl, Properties.class, MediaType.APPLICATION_XML_TYPE);
            if (this.isManageable(properties)) {
                SoftwareId softwareId = new SoftwareId();
                softwareId.setName("Sonar");
                softwareId.setVersion(this.getVersion(properties));
                return softwareId;
            }
            throw new IncompatibleSoftwareException("Url " + url + " is not compatible with Sonar");
        }
        catch (ResourceNotFoundException e) {
            throw new IncompatibleSoftwareException("Url " + url + " is not compatible with Sonar", (Exception)((Object)e));
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("version", (Object)Float.valueOf(this.getVersion())).toString();
    }

    private String getVersion(Properties properties) {
        return new SonarVersionExtractor(properties).version();
    }

    private boolean isManageable(Properties properties) {
        for (Property property : properties.getProperties()) {
            if (!property.isKey(SONAR_CORE_VERSION_KEY)) continue;
            return true;
        }
        return false;
    }
}

