/*
 * Decompiled with CFR 0.152.
 */
package net.awired.visuwall.plugin.sonar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.awired.visuwall.api.domain.BuildTime;
import net.awired.visuwall.api.domain.Commiter;
import net.awired.visuwall.api.domain.ProjectKey;
import net.awired.visuwall.api.domain.SoftwareProjectId;
import net.awired.visuwall.api.domain.State;
import net.awired.visuwall.api.domain.TestResult;
import net.awired.visuwall.api.domain.quality.QualityMeasure;
import net.awired.visuwall.api.domain.quality.QualityMetric;
import net.awired.visuwall.api.domain.quality.QualityResult;
import net.awired.visuwall.api.exception.BuildNotFoundException;
import net.awired.visuwall.api.exception.BuildNumberNotFoundException;
import net.awired.visuwall.api.exception.MavenIdNotFoundException;
import net.awired.visuwall.api.exception.ProjectNotFoundException;
import net.awired.visuwall.api.plugin.capability.MetricCapability;
import net.awired.visuwall.api.plugin.capability.TestCapability;
import net.awired.visuwall.common.client.ResourceNotFoundException;
import net.awired.visuwall.plugin.sonar.Chrono;
import net.awired.visuwall.sonarclient.QualityMeasures;
import net.awired.visuwall.sonarclient.SonarClient;
import net.awired.visuwall.sonarclient.domain.SonarQualityMeasure;
import net.awired.visuwall.sonarclient.domain.SonarQualityMetric;
import net.awired.visuwall.sonarclient.exception.SonarMeasureNotFoundException;
import net.awired.visuwall.sonarclient.exception.SonarMetricsNotFoundException;
import net.awired.visuwall.sonarclient.exception.SonarResourceNotFoundException;
import net.awired.visuwall.sonarclient.resource.Project;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Resource;

public class SonarConnection
implements MetricCapability,
TestCapability {
    private static final Logger LOG;
    private final UUID id = UUID.randomUUID();
    @VisibleForTesting
    SonarClient sonarClient;
    private Map<String, QualityMetric> metricsMap;
    private String[] metricKeys = new String[0];
    private boolean connected;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;

    static {
        SonarConnection.ajc$preClinit();
        LOG = LoggerFactory.getLogger(SonarConnection.class);
    }

    public void connect(String url) {
        String string = url;
        SonarConnection.connect_aroundBody1$advice(this, string, Chrono.aspectOf(), null, ajc$tjp_0);
    }

    public void connect(String url, String login, String password) {
        String string = url;
        String string2 = login;
        String string3 = password;
        SonarConnection.connect_aroundBody3$advice(this, string, string2, string3, Chrono.aspectOf(), null, ajc$tjp_1);
    }

    public Map<String, List<QualityMetric>> getMetricsByCategory() {
        return (Map)SonarConnection.getMetricsByCategory_aroundBody5$advice(this, Chrono.aspectOf(), null, ajc$tjp_2);
    }

    public List<String> findProjectNames() {
        return (List)SonarConnection.findProjectNames_aroundBody7$advice(this, Chrono.aspectOf(), null, ajc$tjp_3);
    }

    public void close() {
        SonarConnection.close_aroundBody9$advice(this, Chrono.aspectOf(), null, ajc$tjp_4);
    }

    public boolean equals(Object o) {
        Object object = o;
        return Conversions.booleanValue((Object)SonarConnection.equals_aroundBody11$advice(this, object, Chrono.aspectOf(), null, ajc$tjp_5));
    }

    public int hashCode() {
        return Conversions.intValue((Object)SonarConnection.hashCode_aroundBody13$advice(this, Chrono.aspectOf(), null, ajc$tjp_6));
    }

    public String getDescription(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        return (String)SonarConnection.getDescription_aroundBody15$advice(this, softwareProjectId2, Chrono.aspectOf(), null, ajc$tjp_7);
    }

    public SoftwareProjectId identify(ProjectKey projectKey) throws ProjectNotFoundException {
        ProjectKey projectKey2 = projectKey;
        return (SoftwareProjectId)SonarConnection.identify_aroundBody17$advice(this, projectKey2, Chrono.aspectOf(), null, ajc$tjp_8);
    }

    public List<SoftwareProjectId> findAllSoftwareProjectIds() {
        return (List)SonarConnection.findAllSoftwareProjectIds_aroundBody19$advice(this, Chrono.aspectOf(), null, ajc$tjp_9);
    }

    public List<SoftwareProjectId> findSoftwareProjectIdsByNames(List<String> names) {
        List<String> list = names;
        return (List)SonarConnection.findSoftwareProjectIdsByNames_aroundBody21$advice(this, list, Chrono.aspectOf(), null, ajc$tjp_10);
    }

    public TestResult analyzeUnitTests(SoftwareProjectId projectId) {
        SoftwareProjectId softwareProjectId = projectId;
        return (TestResult)SonarConnection.analyzeUnitTests_aroundBody23$advice(this, softwareProjectId, Chrono.aspectOf(), null, ajc$tjp_11);
    }

    public TestResult analyzeIntegrationTests(SoftwareProjectId projectId) {
        SoftwareProjectId softwareProjectId = projectId;
        return (TestResult)SonarConnection.analyzeIntegrationTests_aroundBody25$advice(this, softwareProjectId, Chrono.aspectOf(), null, ajc$tjp_12);
    }

    public QualityResult analyzeQuality(SoftwareProjectId projectId, String ... metrics) {
        SoftwareProjectId softwareProjectId = projectId;
        String[] stringArray = metrics;
        return (QualityResult)SonarConnection.analyzeQuality_aroundBody27$advice(this, softwareProjectId, stringArray, Chrono.aspectOf(), null, ajc$tjp_13);
    }

    private void addQualityMeasure(QualityResult qualityResult, String artifactId, String key) {
        block3: {
            try {
                Measure measure = this.sonarClient.findMeasure(artifactId, key);
                if (measure != null && measure.getValue() != null) {
                    SonarQualityMeasure qualityMeasure = QualityMeasures.asQualityMeasure((Measure)measure, (String)key);
                    qualityMeasure.setName(this.metricsMap.get(key).getName());
                    qualityResult.add(key, this.asQualityMeasure(qualityMeasure));
                }
            }
            catch (SonarMeasureNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug(e.getMessage());
            }
        }
    }

    private QualityMeasure asQualityMeasure(SonarQualityMeasure sonarQualityMeasure) {
        QualityMeasure qualityMeasure = new QualityMeasure();
        qualityMeasure.setFormattedValue(sonarQualityMeasure.getFormattedValue());
        qualityMeasure.setKey(sonarQualityMeasure.getKey());
        qualityMeasure.setName(sonarQualityMeasure.getName());
        qualityMeasure.setValue(sonarQualityMeasure.getValue());
        return qualityMeasure;
    }

    public String getMavenId(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException, MavenIdNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        return (String)SonarConnection.getMavenId_aroundBody29$advice(this, softwareProjectId2, Chrono.aspectOf(), null, ajc$tjp_14);
    }

    public String getName(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        return (String)SonarConnection.getName_aroundBody31$advice(this, softwareProjectId2, Chrono.aspectOf(), null, ajc$tjp_15);
    }

    public boolean isClosed() {
        return Conversions.booleanValue((Object)SonarConnection.isClosed_aroundBody33$advice(this, Chrono.aspectOf(), null, ajc$tjp_16));
    }

    public boolean isProjectDisabled(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        return Conversions.booleanValue((Object)SonarConnection.isProjectDisabled_aroundBody35$advice(this, softwareProjectId2, Chrono.aspectOf(), null, ajc$tjp_17));
    }

    private TestResult createUnitTestAnalysis(String artifactId) {
        TestResult unitTestResult;
        block2: {
            unitTestResult = new TestResult();
            try {
                Double coverage = this.sonarClient.findMeasure(artifactId, "coverage").getValue();
                Double failures = this.sonarClient.findMeasure(artifactId, "test_failures").getValue();
                Double errors = this.sonarClient.findMeasure(artifactId, "test_errors").getValue();
                Double passTests = this.sonarClient.findMeasure(artifactId, "tests").getValue();
                int skipCount = this.sonarClient.findMeasure(artifactId, "skipped_tests").getIntValue();
                int failCount = failures.intValue() + errors.intValue();
                int passCount = passTests.intValue() - failCount;
                unitTestResult.setCoverage(coverage.doubleValue());
                unitTestResult.setFailCount(failCount);
                unitTestResult.setSkipCount(skipCount);
                unitTestResult.setPassCount(passCount);
            }
            catch (SonarMeasureNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Unit tests informations are not available for project with artifactId : " + artifactId + ", cause " + e.getMessage());
            }
        }
        return unitTestResult;
    }

    private void initializeMetrics() {
        block2: {
            try {
                this.metricsMap = this.asMetrics(this.sonarClient.findMetrics());
                Set<String> metricKeysSet = this.metricsMap.keySet();
                int countMetricKeys = metricKeysSet.size();
                this.metricKeys = metricKeysSet.toArray(new String[countMetricKeys]);
            }
            catch (SonarMetricsNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Can't initialize metrics", (Throwable)e);
            }
        }
    }

    private Map<String, QualityMetric> asMetrics(Map<String, SonarQualityMetric> sonarMetrics) {
        HashMap<String, QualityMetric> metrics = new HashMap<String, QualityMetric>();
        for (Map.Entry<String, SonarQualityMetric> metric : sonarMetrics.entrySet()) {
            String key = metric.getKey();
            SonarQualityMetric value = metric.getValue();
            QualityMetric qualityMetric = this.asQualityMetric(value);
            metrics.put(key, qualityMetric);
        }
        return metrics;
    }

    private QualityMetric asQualityMetric(SonarQualityMetric sonarQualityMetric) {
        QualityMetric qualityMetric = new QualityMetric();
        qualityMetric.setDescription(sonarQualityMetric.getDescription());
        qualityMetric.setDirection(sonarQualityMetric.getDirection());
        qualityMetric.setDomain(sonarQualityMetric.getDomain());
        qualityMetric.setHidden(sonarQualityMetric.getHidden());
        qualityMetric.setKey(sonarQualityMetric.getKey());
        qualityMetric.setName(sonarQualityMetric.getName());
        qualityMetric.setQualitative(sonarQualityMetric.getQualitative());
        qualityMetric.setUserManaged(sonarQualityMetric.getUserManaged());
        qualityMetric.setValTyp(sonarQualityMetric.getValTyp());
        return qualityMetric;
    }

    public BuildTime getBuildTime(SoftwareProjectId softwareProjectId, Integer buildNumber) throws BuildNotFoundException, ProjectNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        Integer n = buildNumber;
        return (BuildTime)SonarConnection.getBuildTime_aroundBody37$advice(this, softwareProjectId2, n, Chrono.aspectOf(), null, ajc$tjp_18);
    }

    public List<Integer> getBuildNumbers(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        return (List)SonarConnection.getBuildNumbers_aroundBody39$advice(this, softwareProjectId2, Chrono.aspectOf(), null, ajc$tjp_19);
    }

    public State getBuildState(SoftwareProjectId softwareProjectId, Integer buildNumber) throws ProjectNotFoundException, BuildNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        Integer n = buildNumber;
        return (State)SonarConnection.getBuildState_aroundBody41$advice(this, softwareProjectId2, n, Chrono.aspectOf(), null, ajc$tjp_20);
    }

    public Date getEstimatedFinishTime(SoftwareProjectId softwareProjectId, Integer buildNumber) throws ProjectNotFoundException, BuildNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        Integer n = buildNumber;
        return (Date)SonarConnection.getEstimatedFinishTime_aroundBody43$advice(this, softwareProjectId2, n, Chrono.aspectOf(), null, ajc$tjp_21);
    }

    public boolean isBuilding(SoftwareProjectId softwareProjectId, Integer buildNumber) throws ProjectNotFoundException, BuildNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        Integer n = buildNumber;
        return Conversions.booleanValue((Object)SonarConnection.isBuilding_aroundBody45$advice(this, softwareProjectId2, n, Chrono.aspectOf(), null, ajc$tjp_22));
    }

    public int getLastBuildNumber(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException, BuildNumberNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        return Conversions.intValue((Object)SonarConnection.getLastBuildNumber_aroundBody47$advice(this, softwareProjectId2, Chrono.aspectOf(), null, ajc$tjp_23));
    }

    public List<Commiter> getBuildCommiters(SoftwareProjectId softwareProjectId, Integer buildNumber) throws BuildNotFoundException, ProjectNotFoundException {
        SoftwareProjectId softwareProjectId2 = softwareProjectId;
        Integer n = buildNumber;
        return (List)SonarConnection.getBuildCommiters_aroundBody49$advice(this, softwareProjectId2, n, Chrono.aspectOf(), null, ajc$tjp_24);
    }

    private void checkBuildNumber(int buildNumber) {
        Preconditions.checkArgument((buildNumber >= 0 ? 1 : 0) != 0, (Object)"buildNumber must be >= 0");
    }

    private void checkSoftwareProjectId(SoftwareProjectId softwareProjectId) {
        Preconditions.checkNotNull((Object)softwareProjectId, (Object)"softwareProjectId is mandatory");
    }

    private void checkConnected() {
        Preconditions.checkState((boolean)this.connected, (Object)"You must connect your plugin");
    }

    private static final /* synthetic */ Object connect_aroundBody1$advice(SonarConnection ajc$this, String url, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            ajc$this.connect(url, null, null);
            Object var8_7 = null;
            return var8_7;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ void connect_aroundBody2(SonarConnection ajc$this, String url, String login, String password) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Initialize sonar with url " + url);
        }
        if (ajc$this.sonarClient == null) {
            ajc$this.sonarClient = new SonarClient(url, login, password);
        }
        ajc$this.connected = true;
    }

    private static final /* synthetic */ Object connect_aroundBody3$advice(SonarConnection ajc$this, String url, String login, String password, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            SonarConnection.connect_aroundBody2(ajc$this, url, login, password);
            Object var10_9 = null;
            return var10_9;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ Map getMetricsByCategory_aroundBody4(SonarConnection ajc$this) {
        ajc$this.checkConnected();
        if (ajc$this.metricsMap == null) {
            ajc$this.initializeMetrics();
        }
        HashMap<String, ArrayList<QualityMetric>> metricsByDomain = new HashMap<String, ArrayList<QualityMetric>>();
        for (QualityMetric metricValue : ajc$this.metricsMap.values()) {
            String domain = metricValue.getDomain();
            ArrayList<QualityMetric> domainMetrics = (ArrayList<QualityMetric>)metricsByDomain.get(domain);
            if (domainMetrics == null) {
                domainMetrics = new ArrayList<QualityMetric>();
                metricsByDomain.put(domain, domainMetrics);
            }
            domainMetrics.add(metricValue);
        }
        return metricsByDomain;
    }

    private static final /* synthetic */ Object getMetricsByCategory_aroundBody5$advice(SonarConnection ajc$this, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Map map = SonarConnection.getMetricsByCategory_aroundBody4(ajc$this);
            return map;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ List findProjectNames_aroundBody6(SonarConnection ajc$this) {
        ajc$this.checkConnected();
        ArrayList<String> projectNames = new ArrayList<String>();
        try {
            List names = ajc$this.sonarClient.findProjects().getProjects();
            for (Project project : names) {
                projectNames.add(project.getName());
            }
        }
        catch (ResourceNotFoundException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        return projectNames;
    }

    private static final /* synthetic */ Object findProjectNames_aroundBody7$advice(SonarConnection ajc$this, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            List list = SonarConnection.findProjectNames_aroundBody6(ajc$this);
            return list;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ Object close_aroundBody9$advice(SonarConnection ajc$this, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            ajc$this.connected = false;
            Object var7_6 = null;
            return var7_6;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ boolean equals_aroundBody10(SonarConnection ajc$this, Object o) {
        if (o instanceof SonarConnection) {
            SonarConnection s = (SonarConnection)o;
            return ajc$this.id.equals(s.id);
        }
        return false;
    }

    private static final /* synthetic */ Object equals_aroundBody11$advice(SonarConnection ajc$this, Object o, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = Conversions.booleanObject((boolean)SonarConnection.equals_aroundBody10(ajc$this, o));
            return object;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ int hashCode_aroundBody12(SonarConnection ajc$this) {
        return Objects.hashCode((Object[])new Object[]{ajc$this.id});
    }

    private static final /* synthetic */ Object hashCode_aroundBody13$advice(SonarConnection ajc$this, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = Conversions.intObject((int)SonarConnection.hashCode_aroundBody12(ajc$this));
            return object;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ String getDescription_aroundBody14(SonarConnection ajc$this, SoftwareProjectId softwareProjectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        try {
            String artifactId = softwareProjectId.getProjectId();
            Resource resource = ajc$this.sonarClient.findResource(artifactId);
            return resource.getName(true);
        }
        catch (SonarResourceNotFoundException e) {
            throw new ProjectNotFoundException("Can't get description of software project id: " + softwareProjectId, (Throwable)e);
        }
    }

    private static final /* synthetic */ Object getDescription_aroundBody15$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = SonarConnection.getDescription_aroundBody14(ajc$this, softwareProjectId);
            return string;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ SoftwareProjectId identify_aroundBody16(SonarConnection ajc$this, ProjectKey projectKey) {
        ajc$this.checkConnected();
        Preconditions.checkNotNull((Object)projectKey, (Object)"projectKey is mandatory");
        try {
            String mavenId = projectKey.getMavenId();
            if (mavenId != null) {
                Resource resource = ajc$this.sonarClient.findResource(mavenId);
                SoftwareProjectId softwareProjectId = new SoftwareProjectId(resource.getKey());
                return softwareProjectId;
            }
        }
        catch (SonarResourceNotFoundException e) {
            throw new ProjectNotFoundException("Can't identify project key: " + projectKey, (Throwable)e);
        }
        throw new ProjectNotFoundException("Can't identify project key, there is not enough informations: " + projectKey);
    }

    private static final /* synthetic */ Object identify_aroundBody17$advice(SonarConnection ajc$this, ProjectKey projectKey, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            SoftwareProjectId softwareProjectId = SonarConnection.identify_aroundBody16(ajc$this, projectKey);
            return softwareProjectId;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ List findAllSoftwareProjectIds_aroundBody18(SonarConnection ajc$this) {
        ajc$this.checkConnected();
        ArrayList<SoftwareProjectId> softwareProjectIds = new ArrayList<SoftwareProjectId>();
        try {
            List names = ajc$this.sonarClient.findProjects().getProjects();
            for (Project project : names) {
                String key = project.getKey();
                SoftwareProjectId softwareProjectId = new SoftwareProjectId(key);
                softwareProjectIds.add(softwareProjectId);
            }
        }
        catch (ResourceNotFoundException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        return softwareProjectIds;
    }

    private static final /* synthetic */ Object findAllSoftwareProjectIds_aroundBody19$advice(SonarConnection ajc$this, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            List list = SonarConnection.findAllSoftwareProjectIds_aroundBody18(ajc$this);
            return list;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ List findSoftwareProjectIdsByNames_aroundBody20(SonarConnection ajc$this, List names) {
        ajc$this.checkConnected();
        Preconditions.checkNotNull((Object)names, (Object)"names is mandatory");
        ArrayList<SoftwareProjectId> softwareProjectIds = new ArrayList<SoftwareProjectId>();
        try {
            List projects = ajc$this.sonarClient.findProjects().getProjects();
            for (Project project : projects) {
                String name = project.getName();
                if (!names.contains(name)) continue;
                String key = project.getKey();
                SoftwareProjectId softwareProjectId = new SoftwareProjectId(key);
                softwareProjectIds.add(softwareProjectId);
            }
        }
        catch (ResourceNotFoundException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        return softwareProjectIds;
    }

    private static final /* synthetic */ Object findSoftwareProjectIdsByNames_aroundBody21$advice(SonarConnection ajc$this, List names, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            List list = SonarConnection.findSoftwareProjectIdsByNames_aroundBody20(ajc$this, names);
            return list;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ TestResult analyzeUnitTests_aroundBody22(SonarConnection ajc$this, SoftwareProjectId projectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(projectId);
        TestResult unitTestResult = new TestResult();
        String artifactId = projectId.getProjectId();
        if (Strings.isNullOrEmpty((String)artifactId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("can't analyze project " + projectId + " without artifactId. Is it a maven project ?");
            }
        } else {
            unitTestResult = ajc$this.createUnitTestAnalysis(artifactId);
        }
        return unitTestResult;
    }

    private static final /* synthetic */ Object analyzeUnitTests_aroundBody23$advice(SonarConnection ajc$this, SoftwareProjectId projectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            TestResult testResult = SonarConnection.analyzeUnitTests_aroundBody22(ajc$this, projectId);
            return testResult;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ TestResult analyzeIntegrationTests_aroundBody24(SonarConnection ajc$this, SoftwareProjectId projectId) {
        TestResult integrationTestResult;
        block6: {
            ajc$this.checkConnected();
            ajc$this.checkSoftwareProjectId(projectId);
            integrationTestResult = new TestResult();
            try {
                String artifactId = projectId.getProjectId();
                if (Strings.isNullOrEmpty((String)artifactId)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("can't analyze project " + projectId + " without artifactId. Is it a maven project ?");
                    }
                } else {
                    Measure itCoverageMeasure = ajc$this.sonarClient.findMeasure(artifactId, "it_coverage");
                    if (itCoverageMeasure != null) {
                        Double itCoverage = itCoverageMeasure.getValue();
                        integrationTestResult.setCoverage(itCoverage.doubleValue());
                    }
                }
            }
            catch (SonarMeasureNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("Integration tests informations are not available for project " + projectId + ", cause " + e.getMessage());
            }
        }
        return integrationTestResult;
    }

    private static final /* synthetic */ Object analyzeIntegrationTests_aroundBody25$advice(SonarConnection ajc$this, SoftwareProjectId projectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            TestResult testResult = SonarConnection.analyzeIntegrationTests_aroundBody24(ajc$this, projectId);
            return testResult;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ QualityResult analyzeQuality_aroundBody26(SonarConnection ajc$this, SoftwareProjectId projectId, String[] metrics) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(projectId);
        if (ajc$this.metricsMap == null) {
            ajc$this.initializeMetrics();
        }
        if (metrics.length == 0) {
            metrics = ajc$this.metricKeys;
        }
        QualityResult qualityResult = new QualityResult();
        String artifactId = projectId.getProjectId();
        if (!Strings.isNullOrEmpty((String)artifactId)) {
            String[] stringArray = metrics;
            int n = metrics.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                ajc$this.addQualityMeasure(qualityResult, artifactId, key);
                ++n2;
            }
        }
        return qualityResult;
    }

    private static final /* synthetic */ Object analyzeQuality_aroundBody27$advice(SonarConnection ajc$this, SoftwareProjectId projectId, String[] metrics, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            QualityResult qualityResult = SonarConnection.analyzeQuality_aroundBody26(ajc$this, projectId, metrics);
            return qualityResult;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ String getMavenId_aroundBody28(SonarConnection ajc$this, SoftwareProjectId softwareProjectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        try {
            String artifactId = softwareProjectId.getProjectId();
            Resource resource = ajc$this.sonarClient.findResource(artifactId);
            return resource.getKey();
        }
        catch (SonarResourceNotFoundException e) {
            throw new MavenIdNotFoundException("Can't get maven id of software project id: " + softwareProjectId, (Throwable)e);
        }
    }

    private static final /* synthetic */ Object getMavenId_aroundBody29$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = SonarConnection.getMavenId_aroundBody28(ajc$this, softwareProjectId);
            return string;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ String getName_aroundBody30(SonarConnection ajc$this, SoftwareProjectId softwareProjectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        try {
            String artifactId = softwareProjectId.getProjectId();
            Resource resource = ajc$this.sonarClient.findResource(artifactId);
            return resource.getName();
        }
        catch (SonarResourceNotFoundException e) {
            throw new ProjectNotFoundException("Can't get name of software project id: " + softwareProjectId, (Throwable)e);
        }
    }

    private static final /* synthetic */ Object getName_aroundBody31$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = SonarConnection.getName_aroundBody30(ajc$this, softwareProjectId);
            return string;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ boolean isClosed_aroundBody32(SonarConnection ajc$this) {
        return !ajc$this.connected;
    }

    private static final /* synthetic */ Object isClosed_aroundBody33$advice(SonarConnection ajc$this, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = Conversions.booleanObject((boolean)SonarConnection.isClosed_aroundBody32(ajc$this));
            return object;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ boolean isProjectDisabled_aroundBody34(SonarConnection ajc$this, SoftwareProjectId softwareProjectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        return false;
    }

    private static final /* synthetic */ Object isProjectDisabled_aroundBody35$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = Conversions.booleanObject((boolean)SonarConnection.isProjectDisabled_aroundBody34(ajc$this, softwareProjectId));
            return object;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ BuildTime getBuildTime_aroundBody36(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildNumber) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        BuildTime buildTime = new BuildTime();
        buildTime.setDuration(1L);
        buildTime.setStartTime(new Date());
        return buildTime;
    }

    private static final /* synthetic */ Object getBuildTime_aroundBody37$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildNumber, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            BuildTime buildTime = SonarConnection.getBuildTime_aroundBody36(ajc$this, softwareProjectId, buildNumber);
            return buildTime;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ List getBuildNumbers_aroundBody38(SonarConnection ajc$this, SoftwareProjectId softwareProjectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        return Arrays.asList(1);
    }

    private static final /* synthetic */ Object getBuildNumbers_aroundBody39$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            List list = SonarConnection.getBuildNumbers_aroundBody38(ajc$this, softwareProjectId);
            return list;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ State getBuildState_aroundBody40(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildNumber) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        return State.SUCCESS;
    }

    private static final /* synthetic */ Object getBuildState_aroundBody41$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildNumber, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            State state = SonarConnection.getBuildState_aroundBody40(ajc$this, softwareProjectId, buildNumber);
            return state;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ Date getEstimatedFinishTime_aroundBody42(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildNumber) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        return new Date();
    }

    private static final /* synthetic */ Object getEstimatedFinishTime_aroundBody43$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildNumber, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Date date = SonarConnection.getEstimatedFinishTime_aroundBody42(ajc$this, softwareProjectId, buildNumber);
            return date;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ boolean isBuilding_aroundBody44(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildNumber) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        return false;
    }

    private static final /* synthetic */ Object isBuilding_aroundBody45$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildNumber, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = Conversions.booleanObject((boolean)SonarConnection.isBuilding_aroundBody44(ajc$this, softwareProjectId, buildNumber));
            return object;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ int getLastBuildNumber_aroundBody46(SonarConnection ajc$this, SoftwareProjectId softwareProjectId) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        return 1;
    }

    private static final /* synthetic */ Object getLastBuildNumber_aroundBody47$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = Conversions.intObject((int)SonarConnection.getLastBuildNumber_aroundBody46(ajc$this, softwareProjectId));
            return object;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static final /* synthetic */ List getBuildCommiters_aroundBody48(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildNumber) {
        ajc$this.checkConnected();
        ajc$this.checkSoftwareProjectId(softwareProjectId);
        ajc$this.checkBuildNumber(buildNumber);
        return new ArrayList();
    }

    private static final /* synthetic */ Object getBuildCommiters_aroundBody49$advice(SonarConnection ajc$this, SoftwareProjectId softwareProjectId, Integer buildNumber, Chrono ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long start = System.currentTimeMillis();
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            List list = SonarConnection.getBuildCommiters_aroundBody48(ajc$this, softwareProjectId, buildNumber);
            return list;
        }
        finally {
            String prefix = "";
            Signature method = thisJoinPointStaticPart.getSignature();
            long end = System.currentTimeMillis();
            long duration = end - start;
            if (duration > 1100L) {
                prefix = "[SLOW QUERY] ";
            }
            if (duration > 2100L) {
                prefix = "[VERY SLOW QUERY] ";
            }
            if (duration >= 1100L) {
                System.err.print("Chronometer " + prefix + method + " " + duration + " ms\r\n");
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SonarConnection.java", SonarConnection.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "connect", "net.awired.visuwall.plugin.sonar.SonarConnection", "java.lang.String", "url", "", "void"), 77);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "connect", "net.awired.visuwall.plugin.sonar.SonarConnection", "java.lang.String:java.lang.String:java.lang.String", "url:login:password", "", "void"), 82);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findSoftwareProjectIdsByNames", "net.awired.visuwall.plugin.sonar.SonarConnection", "java.util.List", "names", "", "java.util.List"), 195);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "analyzeUnitTests", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "projectId", "", "net.awired.visuwall.api.domain.TestResult"), 216);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "analyzeIntegrationTests", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "projectId", "", "net.awired.visuwall.api.domain.TestResult"), 232);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "analyzeQuality", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId:[Ljava.lang.String;", "projectId:metrics", "", "net.awired.visuwall.api.domain.quality.QualityResult"), 259);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMavenId", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "softwareProjectId", "net.awired.visuwall.api.exception.ProjectNotFoundException:net.awired.visuwall.api.exception.MavenIdNotFoundException", "java.lang.String"), 303);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getName", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "softwareProjectId", "net.awired.visuwall.api.exception.ProjectNotFoundException", "java.lang.String"), 317);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isClosed", "net.awired.visuwall.plugin.sonar.SonarConnection", "", "", "", "boolean"), 330);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isProjectDisabled", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "softwareProjectId", "net.awired.visuwall.api.exception.ProjectNotFoundException", "boolean"), 335);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBuildTime", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId:java.lang.Integer", "softwareProjectId:buildNumber", "net.awired.visuwall.api.exception.BuildNotFoundException:net.awired.visuwall.api.exception.ProjectNotFoundException", "net.awired.visuwall.api.domain.BuildTime"), 404);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBuildNumbers", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "softwareProjectId", "net.awired.visuwall.api.exception.ProjectNotFoundException", "java.util.List"), 414);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMetricsByCategory", "net.awired.visuwall.plugin.sonar.SonarConnection", "", "", "", "java.util.Map"), 93);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBuildState", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId:java.lang.Integer", "softwareProjectId:buildNumber", "net.awired.visuwall.api.exception.ProjectNotFoundException:net.awired.visuwall.api.exception.BuildNotFoundException", "net.awired.visuwall.api.domain.State"), 420);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEstimatedFinishTime", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId:java.lang.Integer", "softwareProjectId:buildNumber", "net.awired.visuwall.api.exception.ProjectNotFoundException:net.awired.visuwall.api.exception.BuildNotFoundException", "java.util.Date"), 427);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isBuilding", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId:java.lang.Integer", "softwareProjectId:buildNumber", "net.awired.visuwall.api.exception.ProjectNotFoundException:net.awired.visuwall.api.exception.BuildNotFoundException", "boolean"), 434);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLastBuildNumber", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "softwareProjectId", "net.awired.visuwall.api.exception.ProjectNotFoundException:net.awired.visuwall.api.exception.BuildNumberNotFoundException", "int"), 441);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBuildCommiters", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId:java.lang.Integer", "softwareProjectId:buildNumber", "net.awired.visuwall.api.exception.BuildNotFoundException:net.awired.visuwall.api.exception.ProjectNotFoundException", "java.util.List"), 448);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findProjectNames", "net.awired.visuwall.plugin.sonar.SonarConnection", "", "", "", "java.util.List"), 112);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "net.awired.visuwall.plugin.sonar.SonarConnection", "", "", "", "void"), 127);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "net.awired.visuwall.plugin.sonar.SonarConnection", "java.lang.Object", "o", "", "boolean"), 132);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "net.awired.visuwall.plugin.sonar.SonarConnection", "", "", "", "int"), 141);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDescription", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.SoftwareProjectId", "softwareProjectId", "net.awired.visuwall.api.exception.ProjectNotFoundException", "java.lang.String"), 146);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "identify", "net.awired.visuwall.plugin.sonar.SonarConnection", "net.awired.visuwall.api.domain.ProjectKey", "projectKey", "net.awired.visuwall.api.exception.ProjectNotFoundException", "net.awired.visuwall.api.domain.SoftwareProjectId"), 160);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findAllSoftwareProjectIds", "net.awired.visuwall.plugin.sonar.SonarConnection", "", "", "", "java.util.List"), 178);
    }
}

