/*
 * Decompiled with CFR 0.152.
 */
package net.awired.visuwall.plugin.continuum;

import java.util.HashMap;
import java.util.Map;
import net.awired.visuwall.api.domain.BuildState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class States {
    private static final Logger LOG = LoggerFactory.getLogger(States.class);
    private static final Map<Integer, BuildState> STATE_MAPPING = new HashMap<Integer, BuildState>();

    public static final BuildState asVisuwallState(int continuumState) {
        BuildState state = STATE_MAPPING.get(continuumState);
        if (state == null) {
            state = BuildState.UNKNOWN;
            LOG.warn(continuumState + " is not available in Continuum plugin. Please report it to Visuwall dev team.");
        }
        return state;
    }

    static {
        STATE_MAPPING.put(2, BuildState.SUCCESS);
        STATE_MAPPING.put(3, BuildState.FAILURE);
    }
}

