/*
 * Decompiled with CFR 0.152.
 */
package net.awired.visuwall.plugin.continuum;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.awired.visuwall.api.domain.BuildState;
import net.awired.visuwall.api.domain.BuildTime;
import net.awired.visuwall.api.domain.Commiter;
import net.awired.visuwall.api.domain.ProjectKey;
import net.awired.visuwall.api.domain.SoftwareProjectId;
import net.awired.visuwall.api.exception.BuildIdNotFoundException;
import net.awired.visuwall.api.exception.BuildNotFoundException;
import net.awired.visuwall.api.exception.ConnectionException;
import net.awired.visuwall.api.exception.MavenIdNotFoundException;
import net.awired.visuwall.api.exception.ProjectNotFoundException;
import net.awired.visuwall.api.exception.ViewNotFoundException;
import net.awired.visuwall.api.plugin.capability.BuildCapability;
import net.awired.visuwall.api.plugin.capability.ViewCapability;
import net.awired.visuwall.plugin.continuum.States;
import org.apache.maven.continuum.xmlrpc.client.ContinuumXmlRpcClient;
import org.apache.maven.continuum.xmlrpc.project.BuildResult;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuumConnection
implements BuildCapability,
ViewCapability {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuumConnection.class);
    private ContinuumXmlRpcClient client;
    private boolean connected;

    public String getMavenId(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException, MavenIdNotFoundException {
        try {
            ProjectSummary projectSummary = this.client.getProjectSummary(this.getId(softwareProjectId));
            return projectSummary.getGroupId() + ":" + projectSummary.getArtifactId();
        }
        catch (Exception e) {
            throw new MavenIdNotFoundException("Cannot find Maven Id for " + softwareProjectId, (Throwable)e);
        }
    }

    private int getId(SoftwareProjectId softwareProjectId) {
        return Integer.parseInt(softwareProjectId.getProjectId());
    }

    public void connect(String url, String login, String password) throws ConnectionException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.client = new ContinuumXmlRpcClient(new URL(url + "/xmlrpc"));
            this.connected = true;
        }
        catch (MalformedURLException e) {
            throw new ConnectionException("Cannot open a connection to " + url, (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void close() {
    }

    public boolean isClosed() {
        return !this.connected;
    }

    public String getDescription(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException {
        try {
            ProjectSummary project = this.findProject(softwareProjectId);
            return project.getDescription();
        }
        catch (Exception e) {
            throw new ProjectNotFoundException((Throwable)e);
        }
    }

    public String getName(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException {
        try {
            ProjectSummary project = this.findProject(softwareProjectId);
            return project.getName();
        }
        catch (Exception e) {
            throw new ProjectNotFoundException((Throwable)e);
        }
    }

    private ProjectSummary findProject(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException {
        try {
            return this.client.getProjectSummary(this.getId(softwareProjectId));
        }
        catch (Exception e) {
            throw new ProjectNotFoundException("Cannot find " + softwareProjectId, (Throwable)e);
        }
    }

    public SoftwareProjectId identify(ProjectKey projectKey) throws ProjectNotFoundException {
        try {
            String projectMavenId = projectKey.getMavenId();
            List<ProjectSummary> projects = this.findAllProjects();
            for (ProjectSummary project : projects) {
                String groupId = project.getGroupId();
                String artifactId = project.getArtifactId();
                String mavenId = groupId + ":" + artifactId;
                if (!mavenId.equals(projectMavenId)) continue;
                return new SoftwareProjectId(Integer.toString(project.getId()));
            }
        }
        catch (Exception e) {
            throw new ProjectNotFoundException("Cannot identify " + projectKey, (Throwable)e);
        }
        throw new ProjectNotFoundException("Cannot identify " + projectKey);
    }

    private List<ProjectSummary> findAllProjects() throws Exception {
        List pgs = this.client.getAllProjectGroups();
        ArrayList<ProjectSummary> ps = new ArrayList<ProjectSummary>();
        for (ProjectGroupSummary projectGroupSummary : pgs) {
            ps.addAll(this.client.getProjects(projectGroupSummary.getId()));
        }
        return ps;
    }

    public Map<SoftwareProjectId, String> listSoftwareProjectIds() {
        HashMap<SoftwareProjectId, String> projectIds = new HashMap<SoftwareProjectId, String>();
        try {
            List<ProjectSummary> projects = this.findAllProjects();
            for (ProjectSummary project : projects) {
                SoftwareProjectId projectId = new SoftwareProjectId(Integer.toString(project.getId()));
                projectIds.put(projectId, project.getName());
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        return projectIds;
    }

    public boolean isProjectDisabled(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException {
        return false;
    }

    public List<Commiter> getBuildCommiters(SoftwareProjectId softwareProjectId, String buildId) throws BuildNotFoundException, ProjectNotFoundException {
        TreeSet<Commiter> commiters = new TreeSet<Commiter>();
        try {
            BuildResult buildResult = this.getBuildResult(softwareProjectId, buildId);
            ScmResult scmResult = buildResult.getScmResult();
            List changes = scmResult.getChanges();
            for (ChangeSet change : changes) {
                String author = change.getAuthor();
                Commiter commiter = new Commiter(author);
                commiter.setName(author);
                commiters.add(commiter);
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage());
        }
        return new ArrayList<Commiter>(commiters);
    }

    private BuildResult getBuildResult(SoftwareProjectId softwareProjectId, String buildId) throws Exception {
        BuildResult buildResult = this.client.getBuildResult(this.getId(softwareProjectId), Integer.parseInt(buildId));
        return buildResult;
    }

    public BuildTime getBuildTime(SoftwareProjectId softwareProjectId, String buildId) throws BuildNotFoundException, ProjectNotFoundException {
        try {
            BuildResult buildResult = this.getBuildResult(softwareProjectId, buildId);
            long startTime = buildResult.getStartTime();
            long endTime = buildResult.getEndTime();
            BuildTime buildTime = new BuildTime();
            buildTime.setStartTime(new Date(startTime));
            buildTime.setDuration(endTime - startTime);
            return buildTime;
        }
        catch (Exception e) {
            throw new BuildNotFoundException("Cannot get build time for " + softwareProjectId + " and build id " + buildId, (Throwable)e);
        }
    }

    public List<String> getBuildIds(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException {
        ArrayList<String> buildIds = new ArrayList<String>();
        ProjectSummary project = this.findProject(softwareProjectId);
        Integer latestBuildId = project.getLatestBuildId();
        buildIds.add(latestBuildId.toString());
        return buildIds;
    }

    public BuildState getBuildState(SoftwareProjectId projectId, String buildId) throws ProjectNotFoundException, BuildNotFoundException {
        int id = this.getId(projectId);
        try {
            BuildResult buildResult = this.client.getBuildResult(id, Integer.parseInt(buildId));
            return States.asVisuwallState(buildResult.getState());
        }
        catch (NumberFormatException e) {
            throw new BuildNotFoundException((Throwable)e);
        }
        catch (Exception e) {
            throw new BuildNotFoundException((Throwable)e);
        }
    }

    public Date getEstimatedFinishTime(SoftwareProjectId projectId, String buildId) throws ProjectNotFoundException, BuildNotFoundException {
        return new Date();
    }

    public boolean isBuilding(SoftwareProjectId softwareProjectId, String buildId) throws ProjectNotFoundException, BuildNotFoundException {
        return false;
    }

    public String getLastBuildId(SoftwareProjectId softwareProjectId) throws ProjectNotFoundException, BuildIdNotFoundException {
        ProjectSummary project = this.findProject(softwareProjectId);
        return Integer.toString(project.getLatestBuildId());
    }

    public List<SoftwareProjectId> findSoftwareProjectIdsByViews(List<String> views) {
        ArrayList<SoftwareProjectId> softwareProjectIds = new ArrayList<SoftwareProjectId>();
        try {
            List pgs = this.client.getAllProjectGroups();
            for (String viewName : views) {
                for (ProjectGroupSummary projectGroupSummary : pgs) {
                    if (!projectGroupSummary.getName().equals(viewName)) continue;
                    List projects = this.client.getProjects(projectGroupSummary.getId());
                    for (ProjectSummary project : projects) {
                        SoftwareProjectId projectId = new SoftwareProjectId(Integer.toString(project.getId()));
                        softwareProjectIds.add(projectId);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot get all projects groups", (Throwable)e);
        }
        return softwareProjectIds;
    }

    public List<String> findViews() {
        ArrayList<String> views = new ArrayList<String>();
        try {
            List pgs = this.client.getAllProjectGroups();
            for (ProjectGroupSummary projectGroupSummary : pgs) {
                String name = projectGroupSummary.getName();
                views.add(name);
            }
            Collections.sort(views);
        }
        catch (Exception e) {
            LOG.warn("Cannot get all projects groups", (Throwable)e);
        }
        return views;
    }

    public List<String> findProjectNamesByView(String viewName) throws ViewNotFoundException {
        ArrayList<String> projectNames = new ArrayList<String>();
        try {
            List pgs = this.client.getAllProjectGroups();
            for (ProjectGroupSummary projectGroupSummary : pgs) {
                if (!projectGroupSummary.getName().equals(viewName)) continue;
                List projects = this.client.getProjects(projectGroupSummary.getId());
                for (ProjectSummary project : projects) {
                    projectNames.add(project.getName());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot get all projects groups", (Throwable)e);
        }
        return projectNames;
    }
}

