/*
 * Decompiled with CFR 0.152.
 */
package net.awired.clients.sonar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import net.awired.clients.common.GenericSoftwareClient;
import net.awired.clients.common.ResourceNotFoundException;
import net.awired.clients.sonar.domain.SonarMetrics;
import net.awired.clients.sonar.domain.SonarQualityMetric;
import net.awired.clients.sonar.exception.SonarMeasureNotFoundException;
import net.awired.clients.sonar.exception.SonarMetricsNotFoundException;
import net.awired.clients.sonar.exception.SonarProjectNotFoundException;
import net.awired.clients.sonar.exception.SonarProjectsNotFoundException;
import net.awired.clients.sonar.exception.SonarResourceNotFoundException;
import net.awired.clients.sonar.resource.Project;
import net.awired.clients.sonar.resource.Projects;
import org.apache.commons.lang.StringUtils;
import org.sonar.wsclient.connectors.ConnectionException;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;

public class Sonar {
    @VisibleForTesting
    GenericSoftwareClient client;
    @VisibleForTesting
    org.sonar.wsclient.Sonar sonar;
    private String sonarUrl;

    public Sonar(String url) {
        this(url, null, null);
    }

    public Sonar(String url, String login, String password) {
        Preconditions.checkNotNull((Object)url, (Object)"sonarUrl is mandatory");
        Preconditions.checkArgument((!url.isEmpty() ? 1 : 0) != 0, (Object)"sonarUrl can't be empty");
        this.sonarUrl = url;
        if (StringUtils.isNotBlank((String)login) && StringUtils.isNotBlank((String)password)) {
            this.sonar = org.sonar.wsclient.Sonar.create((String)url, (String)login, (String)password);
            this.client = new GenericSoftwareClient(login, password);
        } else {
            this.sonar = org.sonar.wsclient.Sonar.create((String)url);
            this.client = new GenericSoftwareClient();
        }
    }

    public Measure findMeasure(String artifactId, String measureKey) throws SonarMeasureNotFoundException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)artifactId) ? 1 : 0) != 0, (Object)"artifactId is a mandatory parameter");
        Preconditions.checkNotNull((Object)measureKey, (Object)"measureKey is a mandatory parameter");
        return this.findMeasureFromSonar(artifactId, measureKey);
    }

    private Measure findMeasureFromSonar(String artifactId, String measureKey) throws SonarMeasureNotFoundException {
        ResourceQuery query = ResourceQuery.createForMetrics((String)artifactId, (String[])new String[]{measureKey});
        try {
            Resource resource = (Resource)this.sonar.find((Query)query);
            if (resource == null) {
                throw new SonarMeasureNotFoundException("Metric " + measureKey + " not found for project " + artifactId + " in Sonar " + this.sonarUrl);
            }
            return resource.getMeasure(measureKey);
        }
        catch (ConnectionException e) {
            throw new SonarMeasureNotFoundException("Metric " + measureKey + " not found for project " + artifactId + " in Sonar " + this.sonarUrl, e);
        }
    }

    public Resource findResource(String resourceId) throws SonarResourceNotFoundException {
        Preconditions.checkNotNull((Object)resourceId, (Object)"resourceId is mandatory");
        ResourceQuery query = new ResourceQuery(resourceId);
        try {
            Resource resource = (Resource)this.sonar.find((Query)query);
            if (resource == null) {
                throw new SonarResourceNotFoundException("Resource " + resourceId + " not found in Sonar " + this.sonarUrl);
            }
            return resource;
        }
        catch (ConnectionException e) {
            throw new SonarResourceNotFoundException("Resource " + resourceId + " not found in Sonar " + this.sonarUrl, e);
        }
    }

    public Map<String, SonarQualityMetric> findMetrics() throws SonarMetricsNotFoundException {
        try {
            String metricUrl = this.sonarUrl + "/api/metrics?format=xml";
            SonarMetrics sonarMetrics = (SonarMetrics)this.client.resource(metricUrl, SonarMetrics.class);
            HashMap<String, SonarQualityMetric> qualityMetrics = new HashMap<String, SonarQualityMetric>();
            for (SonarQualityMetric metric : sonarMetrics.metric) {
                qualityMetrics.put(metric.getKey(), metric);
            }
            return qualityMetrics;
        }
        catch (ResourceNotFoundException e) {
            throw new SonarMetricsNotFoundException("Can't find sonar metrics with Sonar: " + this.sonarUrl, (Exception)((Object)e));
        }
    }

    public Projects findProjects() throws SonarProjectsNotFoundException {
        String projectsUrl = this.sonarUrl + "/api/projects";
        try {
            return (Projects)this.client.resource(projectsUrl, Projects.class, MediaType.APPLICATION_XML_TYPE);
        }
        catch (ResourceNotFoundException e) {
            throw new SonarProjectsNotFoundException("Can't find Sonar projects", e);
        }
    }

    public Project findProject(String projectKey) throws SonarProjectNotFoundException {
        Preconditions.checkNotNull((Object)projectKey, (Object)"projectKey is mandatory");
        try {
            List<Project> projects = this.findProjects().getProjects();
            for (Project project : projects) {
                if (!project.getKey().equals(projectKey)) continue;
                return project;
            }
            throw new SonarProjectNotFoundException("Can't find Sonar project with resourceId: '" + projectKey + "'");
        }
        catch (SonarProjectsNotFoundException e) {
            throw new SonarProjectNotFoundException("Can't find Sonar project with resourceId: '" + projectKey + "'", e);
        }
    }
}

