/**
 *     Copyright (C) 2010 Julien SMADJA <julien dot smadja at gmail dot com> - Arnaud LEMAIRE <alemaire at norad dot fr>
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *             http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 */

package net.awired.clients.sonar.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import com.google.common.base.Objects;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "metric")
public final class SonarQualityMetric {

    String key;
    String name;
    String description;
    String domain;
    Boolean qualitative;
    Integer direction;
    Boolean userManaged;
    String valTyp;
    Boolean hidden;

    public String getKey() {
        return key;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public String getDomain() {
        return domain;
    }

    public Boolean getQualitative() {
        return qualitative;
    }

    public Integer getDirection() {
        return direction;
    }

    public Boolean getUserManaged() {
        return userManaged;
    }

    public String getValTyp() {
        return valTyp;
    }

    public Boolean getHidden() {
        return hidden;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this) //
                .add("description", description)//
                .add("direction", direction)//
                .add("domain", domain)//
                .add("hidden", hidden)//
                .add("key", key)//
                .add("name", name)//
                .add("qualitative", qualitative)//
                .add("userManaged", userManaged)//
                .add("valTyp", valTyp)//
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof SonarQualityMetric) {
            return Objects.equal(key, ((SonarQualityMetric) o).key);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(description, domain, key, name);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setQualitative(Boolean qualitative) {
        this.qualitative = qualitative;
    }

    public void setDirection(Integer direction) {
        this.direction = direction;
    }

    public void setUserManaged(Boolean userManaged) {
        this.userManaged = userManaged;
    }

    public void setValTyp(String valTyp) {
        this.valTyp = valTyp;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

}
