/*
 * Decompiled with CFR 0.152.
 */
package net.avianlabs.solana.domain.program;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.avianlabs.solana.domain.core.AccountMeta;
import net.avianlabs.solana.domain.core.TransactionInstruction;
import net.avianlabs.solana.domain.program.Program;
import net.avianlabs.solana.tweetnacl.ed25519.PublicKey;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rJ\u001e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\rJ\u0016\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J&\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\rJ\u001e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lnet/avianlabs/solana/domain/program/SystemProgram;", "Lnet/avianlabs/solana/domain/program/Program;", "<init>", "()V", "programId", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "getProgramId", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "SYSVAR_RENT_ACCOUNT", "getSYSVAR_RENT_ACCOUNT", "SYSVAR_RECENT_BLOCKHASH", "getSYSVAR_RECENT_BLOCKHASH", "NONCE_ACCOUNT_LENGTH", "", "getNONCE_ACCOUNT_LENGTH", "()J", "createAccount", "Lnet/avianlabs/solana/domain/core/TransactionInstruction;", "fromPublicKey", "newAccountPublicKey", "lamports", "space", "transfer", "toPublicKey", "nonceInitialize", "nonceAccount", "authorized", "nonceAdvance", "nonceWithdraw", "nonceAuthorize", "newAuthorized", "Instruction", "solana-kotlin"})
public final class SystemProgram
implements Program {
    @NotNull
    public static final SystemProgram INSTANCE = new SystemProgram();
    @NotNull
    private static final PublicKey programId = PublicKey.Companion.fromBase58("11111111111111111111111111111111");
    @NotNull
    private static final PublicKey SYSVAR_RENT_ACCOUNT = PublicKey.Companion.fromBase58("SysvarRent111111111111111111111111111111111");
    @NotNull
    private static final PublicKey SYSVAR_RECENT_BLOCKHASH = PublicKey.Companion.fromBase58("SysvarRecentB1ockHashes11111111111111111111");
    private static final long NONCE_ACCOUNT_LENGTH = 80L;

    private SystemProgram() {
    }

    @Override
    @NotNull
    public PublicKey getProgramId() {
        return programId;
    }

    @NotNull
    public final PublicKey getSYSVAR_RENT_ACCOUNT() {
        return SYSVAR_RENT_ACCOUNT;
    }

    @NotNull
    public final PublicKey getSYSVAR_RECENT_BLOCKHASH() {
        return SYSVAR_RECENT_BLOCKHASH;
    }

    public final long getNONCE_ACCOUNT_LENGTH() {
        return NONCE_ACCOUNT_LENGTH;
    }

    @NotNull
    public final TransactionInstruction createAccount(@NotNull PublicKey fromPublicKey, @NotNull PublicKey newAccountPublicKey, long lamports, long space) {
        Intrinsics.checkNotNullParameter((Object)fromPublicKey, (String)"fromPublicKey");
        Intrinsics.checkNotNullParameter((Object)newAccountPublicKey, (String)"newAccountPublicKey");
        Object[] objectArray = new AccountMeta[]{new AccountMeta(fromPublicKey, true, true), new AccountMeta(newAccountPublicKey, true, true)};
        return Program.Companion.createTransactionInstruction$solana_kotlin(this.getProgramId(), CollectionsKt.listOf((Object[])objectArray), new Buffer().writeIntLe(Instruction.CreateAccount.getIndex-pVg5ArA()).writeLongLe(lamports).writeLongLe(space).write(this.getProgramId().getBytes()).readByteArray());
    }

    @NotNull
    public final TransactionInstruction transfer(@NotNull PublicKey fromPublicKey, @NotNull PublicKey toPublicKey, long lamports) {
        Intrinsics.checkNotNullParameter((Object)fromPublicKey, (String)"fromPublicKey");
        Intrinsics.checkNotNullParameter((Object)toPublicKey, (String)"toPublicKey");
        Object[] objectArray = new AccountMeta[]{new AccountMeta(fromPublicKey, true, true), new AccountMeta(toPublicKey, false, true)};
        return Program.Companion.createTransactionInstruction$solana_kotlin(this.getProgramId(), CollectionsKt.listOf((Object[])objectArray), new Buffer().writeIntLe(Instruction.Transfer.getIndex-pVg5ArA()).writeLongLe(lamports).readByteArray());
    }

    @NotNull
    public final TransactionInstruction nonceInitialize(@NotNull PublicKey nonceAccount, @NotNull PublicKey authorized) {
        Intrinsics.checkNotNullParameter((Object)nonceAccount, (String)"nonceAccount");
        Intrinsics.checkNotNullParameter((Object)authorized, (String)"authorized");
        Object[] objectArray = new AccountMeta[]{new AccountMeta(nonceAccount, false, true), new AccountMeta(SYSVAR_RECENT_BLOCKHASH, false, false), new AccountMeta(SYSVAR_RENT_ACCOUNT, false, false)};
        return Program.Companion.createTransactionInstruction$solana_kotlin(this.getProgramId(), CollectionsKt.listOf((Object[])objectArray), new Buffer().writeIntLe(Instruction.InitializeNonceAccount.getIndex-pVg5ArA()).write(authorized.getBytes()).readByteArray());
    }

    @NotNull
    public final TransactionInstruction nonceAdvance(@NotNull PublicKey nonceAccount, @NotNull PublicKey authorized) {
        Intrinsics.checkNotNullParameter((Object)nonceAccount, (String)"nonceAccount");
        Intrinsics.checkNotNullParameter((Object)authorized, (String)"authorized");
        Object[] objectArray = new AccountMeta[]{new AccountMeta(nonceAccount, false, true), new AccountMeta(SYSVAR_RECENT_BLOCKHASH, false, false), new AccountMeta(authorized, true, false)};
        return Program.Companion.createTransactionInstruction$solana_kotlin(this.getProgramId(), CollectionsKt.listOf((Object[])objectArray), new Buffer().writeIntLe(Instruction.AdvanceNonceAccount.getIndex-pVg5ArA()).readByteArray());
    }

    @NotNull
    public final TransactionInstruction nonceWithdraw(@NotNull PublicKey nonceAccount, @NotNull PublicKey authorized, @NotNull PublicKey toPublicKey, long lamports) {
        Intrinsics.checkNotNullParameter((Object)nonceAccount, (String)"nonceAccount");
        Intrinsics.checkNotNullParameter((Object)authorized, (String)"authorized");
        Intrinsics.checkNotNullParameter((Object)toPublicKey, (String)"toPublicKey");
        Object[] objectArray = new AccountMeta[]{new AccountMeta(nonceAccount, false, true), new AccountMeta(toPublicKey, false, true), new AccountMeta(SYSVAR_RECENT_BLOCKHASH, false, false), new AccountMeta(SYSVAR_RENT_ACCOUNT, false, false), new AccountMeta(authorized, true, false)};
        return Program.Companion.createTransactionInstruction$solana_kotlin(this.getProgramId(), CollectionsKt.listOf((Object[])objectArray), new Buffer().writeIntLe(Instruction.WithdrawNonceAccount.getIndex-pVg5ArA()).writeLongLe(lamports).readByteArray());
    }

    @NotNull
    public final TransactionInstruction nonceAuthorize(@NotNull PublicKey nonceAccount, @NotNull PublicKey authorized, @NotNull PublicKey newAuthorized) {
        Intrinsics.checkNotNullParameter((Object)nonceAccount, (String)"nonceAccount");
        Intrinsics.checkNotNullParameter((Object)authorized, (String)"authorized");
        Intrinsics.checkNotNullParameter((Object)newAuthorized, (String)"newAuthorized");
        Object[] objectArray = new AccountMeta[]{new AccountMeta(nonceAccount, false, true), new AccountMeta(authorized, true, false)};
        return Program.Companion.createTransactionInstruction$solana_kotlin(this.getProgramId(), CollectionsKt.listOf((Object[])objectArray), new Buffer().writeIntLe(Instruction.AuthorizeNonceAccount.getIndex-pVg5ArA()).write(newAuthorized.getBytes()).readByteArray());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001b"}, d2={"Lnet/avianlabs/solana/domain/program/SystemProgram$Instruction;", "", "index", "Lkotlin/UInt;", "<init>", "(Ljava/lang/String;II)V", "getIndex-pVg5ArA", "()I", "I", "CreateAccount", "Assign", "Transfer", "CreateAccountWithSeed", "AdvanceNonceAccount", "WithdrawNonceAccount", "InitializeNonceAccount", "AuthorizeNonceAccount", "Allocate", "AllocateWithSeed", "AssignWithSeed", "TransferWithSeed", "AdvanceNonceAccountWithSeed", "Push", "Pop", "Invoke", "Print", "Halt", "solana-kotlin"})
    public static final class Instruction
    extends Enum<Instruction> {
        private final int index;
        public static final /* enum */ Instruction CreateAccount = new Instruction(0);
        public static final /* enum */ Instruction Assign = new Instruction(1);
        public static final /* enum */ Instruction Transfer = new Instruction(2);
        public static final /* enum */ Instruction CreateAccountWithSeed = new Instruction(3);
        public static final /* enum */ Instruction AdvanceNonceAccount = new Instruction(4);
        public static final /* enum */ Instruction WithdrawNonceAccount = new Instruction(5);
        public static final /* enum */ Instruction InitializeNonceAccount = new Instruction(6);
        public static final /* enum */ Instruction AuthorizeNonceAccount = new Instruction(7);
        public static final /* enum */ Instruction Allocate = new Instruction(8);
        public static final /* enum */ Instruction AllocateWithSeed = new Instruction(9);
        public static final /* enum */ Instruction AssignWithSeed = new Instruction(10);
        public static final /* enum */ Instruction TransferWithSeed = new Instruction(11);
        public static final /* enum */ Instruction AdvanceNonceAccountWithSeed = new Instruction(12);
        public static final /* enum */ Instruction Push = new Instruction(13);
        public static final /* enum */ Instruction Pop = new Instruction(14);
        public static final /* enum */ Instruction Invoke = new Instruction(15);
        public static final /* enum */ Instruction Print = new Instruction(16);
        public static final /* enum */ Instruction Halt = new Instruction(17);
        private static final /* synthetic */ Instruction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Instruction(int index) {
            this.index = index;
        }

        public final int getIndex-pVg5ArA() {
            return this.index;
        }

        public static Instruction[] values() {
            return (Instruction[])$VALUES.clone();
        }

        public static Instruction valueOf(String value) {
            return Enum.valueOf(Instruction.class, value);
        }

        @NotNull
        public static EnumEntries<Instruction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = instructionArray = new Instruction[]{Instruction.CreateAccount, Instruction.Assign, Instruction.Transfer, Instruction.CreateAccountWithSeed, Instruction.AdvanceNonceAccount, Instruction.WithdrawNonceAccount, Instruction.InitializeNonceAccount, Instruction.AuthorizeNonceAccount, Instruction.Allocate, Instruction.AllocateWithSeed, Instruction.AssignWithSeed, Instruction.TransferWithSeed, Instruction.AdvanceNonceAccountWithSeed, Instruction.Push, Instruction.Pop, Instruction.Invoke, Instruction.Print, Instruction.Halt};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

