/*
 * Decompiled with CFR 0.152.
 */
package net.avianlabs.solana.domain.program;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.avianlabs.solana.domain.core.AccountMeta;
import net.avianlabs.solana.domain.core.TransactionInstruction;
import net.avianlabs.solana.domain.program.ProgramDerivedAddress;
import net.avianlabs.solana.tweetnacl.ed25519.PublicKey;
import net.avianlabs.solana.tweetnacl.vendor.Sha256;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lnet/avianlabs/solana/domain/program/Program;", "", "programId", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "getProgramId", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "Companion", "solana-kotlin"})
public interface Program {
    @NotNull
    public static final Companion Companion = net.avianlabs.solana.domain.program.Program$Companion.$$INSTANCE;

    @NotNull
    public PublicKey getProgramId();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ#\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0011J#\u0010\u0012\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lnet/avianlabs/solana/domain/program/Program$Companion;", "", "<init>", "()V", "createTransactionInstruction", "Lnet/avianlabs/solana/domain/core/TransactionInstruction;", "programId", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "keys", "", "Lnet/avianlabs/solana/domain/core/AccountMeta;", "data", "", "createTransactionInstruction$solana_kotlin", "findProgramAddress", "Lnet/avianlabs/solana/domain/program/ProgramDerivedAddress;", "seeds", "findProgramAddress$solana_kotlin", "createProgramAddress", "createProgramAddress$solana_kotlin", "solana-kotlin"})
    @SourceDebugExtension(value={"SMAP\nProgram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Program.kt\nnet/avianlabs/solana/domain/program/Program$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1863#2,2:69\n1863#2,2:71\n*S KotlinDebug\n*F\n+ 1 Program.kt\nnet/avianlabs/solana/domain/program/Program$Companion\n*L\n43#1:69,2\n51#1:71,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final TransactionInstruction createTransactionInstruction$solana_kotlin(@NotNull PublicKey programId, @NotNull List<AccountMeta> keys, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)programId, (String)"programId");
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new TransactionInstruction(programId, keys, data);
        }

        @NotNull
        public final ProgramDerivedAddress findProgramAddress$solana_kotlin(@NotNull List<byte[]> seeds, @NotNull PublicKey programId) {
            Intrinsics.checkNotNullParameter(seeds, (String)"seeds");
            Intrinsics.checkNotNullParameter((Object)programId, (String)"programId");
            Object address = null;
            byte bumpSeed = -1;
            while (Intrinsics.compare((int)(bumpSeed & 0xFF), (int)(UByte.constructor-impl((byte)((byte)0)) & 0xFF)) > 0) {
                Object object;
                try {
                    object = new byte[]{bumpSeed};
                    object = this.createProgramAddress$solana_kotlin(CollectionsKt.plus((Collection)seeds, (Object)object), programId);
                }
                catch (Exception e) {
                    byte by = bumpSeed;
                    bumpSeed = UByte.constructor-impl((byte)((byte)(by + -1)));
                    continue;
                }
                address = object;
                return new ProgramDerivedAddress((PublicKey)address, bumpSeed, null);
            }
            throw new Exception("Unable to find a viable program address nonce");
        }

        @NotNull
        public final PublicKey createProgramAddress$solana_kotlin(@NotNull List<byte[]> seeds, @NotNull PublicKey programId) {
            Intrinsics.checkNotNullParameter(seeds, (String)"seeds");
            Intrinsics.checkNotNullParameter((Object)programId, (String)"programId");
            if (seeds.size() > 16) {
                throw new RuntimeException("max seed length exceeded: " + seeds.size());
            }
            Iterable $this$forEach$iv = seeds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                byte[] seed = (byte[])element$iv;
                boolean bl = false;
                if (seed.length <= 32) continue;
                throw new RuntimeException("max seed length exceeded: " + seed.length);
            }
            Buffer $this$createProgramAddress_u24lambda_u242 = $i$f$forEach = new Buffer();
            boolean bl = false;
            Iterable $this$forEach$iv2 = seeds;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                byte[] seed = (byte[])element$iv;
                boolean bl2 = false;
                $this$createProgramAddress_u24lambda_u242.write(seed);
            }
            byte[] bytes = $i$f$forEach.write(programId.getBytes()).write(StringsKt.encodeToByteArray((String)"ProgramDerivedAddress")).readByteArray();
            byte[] hash = Sha256.INSTANCE.digest(bytes);
            if (new PublicKey(hash).isOnCurve()) {
                throw new RuntimeException("Invalid seeds, address must fall off the curve");
            }
            return new PublicKey(hash);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

