/*
 * Decompiled with CFR 0.152.
 */
package net.avianlabs.solana.domain.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.avianlabs.solana.domain.core.AccountMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0014\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fR,\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\bj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR!\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0012j\b\u0012\u0004\u0012\u00020\u0007`\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lnet/avianlabs/solana/domain/core/AccountKeysList;", "", "<init>", "()V", "accounts", "Lkotlin/collections/LinkedHashMap;", "", "Lnet/avianlabs/solana/domain/core/AccountMeta;", "Ljava/util/LinkedHashMap;", "Ljava/util/LinkedHashMap;", "add", "", "accountMeta", "addAll", "metas", "", "list", "Lkotlin/collections/ArrayList;", "Ljava/util/ArrayList;", "getList", "()Ljava/util/ArrayList;", "Companion", "solana-kotlin"})
public final class AccountKeysList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashMap<String, AccountMeta> accounts = new LinkedHashMap();
    @NotNull
    private static final Comparator<AccountMeta> metaComparator = AccountKeysList::metaComparator$lambda$0;

    public final void add(@NotNull AccountMeta accountMeta) {
        Intrinsics.checkNotNullParameter((Object)accountMeta, (String)"accountMeta");
        String key = accountMeta.getPublicKey().toString();
        AccountMeta existing = this.accounts.get(key);
        if (existing != null) {
            ((Map)this.accounts).put(key, AccountMeta.copy$default(existing, null, accountMeta.isSigner() || existing.isSigner(), accountMeta.isWritable() || existing.isWritable(), 1, null));
        } else {
            ((Map)this.accounts).put(key, accountMeta);
        }
    }

    public final void addAll(@NotNull Collection<AccountMeta> metas) {
        Intrinsics.checkNotNullParameter(metas, (String)"metas");
        for (AccountMeta meta : metas) {
            this.add(meta);
        }
    }

    @NotNull
    public final ArrayList<AccountMeta> getList() {
        ArrayList<AccountMeta> accountKeysList = new ArrayList<AccountMeta>(this.accounts.values());
        CollectionsKt.sortWith((List)accountKeysList, metaComparator);
        return accountKeysList;
    }

    private static final int metaComparator$lambda$0(AccountMeta am1, AccountMeta am2) {
        return am1.isSigner() && !am2.isSigner() ? -1 : (!am1.isSigner() && am2.isSigner() ? 1 : (am1.isWritable() && !am2.isWritable() ? -1 : (!am1.isWritable() && am2.isWritable() ? 1 : 0)));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/avianlabs/solana/domain/core/AccountKeysList$Companion;", "", "<init>", "()V", "metaComparator", "Ljava/util/Comparator;", "Lnet/avianlabs/solana/domain/core/AccountMeta;", "solana-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

