/*
 * Decompiled with CFR 0.152.
 */
package net.avianlabs.solana.domain.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.avianlabs.solana.domain.core.Message;
import net.avianlabs.solana.domain.core.TransactionInstruction;
import net.avianlabs.solana.tweetnacl.TweetNaCl;
import net.avianlabs.solana.tweetnacl.ed25519.Ed25519Keypair;
import net.avianlabs.solana.tweetnacl.ed25519.PublicKey;
import net.avianlabs.solana.tweetnacl.vendor.Base58Kt;
import net.avianlabs.solana.vendor.ShortvecEncoding;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u000bJ\u0010\u0010\u0014\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0006J\u0018\u0010\u0019\u001a\u00020\u00002\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`\u001c0\rJ\u0012\u0010\u0019\u001a\u00020\u00002\n\u0010\u001d\u001a\u00060\u001bj\u0002`\u001cJ\b\u0010\u001e\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lnet/avianlabs/solana/domain/core/Transaction;", "", "message", "Lnet/avianlabs/solana/domain/core/Message;", "_signatures", "", "", "(Lnet/avianlabs/solana/domain/core/Message;Ljava/util/List;)V", "getMessage", "()Lnet/avianlabs/solana/domain/core/Message;", "serializedMessage", "", "signatures", "", "getSignatures", "()Ljava/util/List;", "addInstruction", "instruction", "Lnet/avianlabs/solana/domain/core/TransactionInstruction;", "serialize", "setFeePayer", "feePayer", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "setRecentBlockHash", "recentBlockhash", "sign", "signers", "Lnet/avianlabs/solana/tweetnacl/ed25519/Ed25519Keypair;", "Lnet/avianlabs/solana/domain/core/Signer;", "signer", "toString", "solana-kotlin"})
@SourceDebugExtension(value={"SMAP\nTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transaction.kt\nnet/avianlabs/solana/domain/core/Transaction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class Transaction {
    @NotNull
    private final Message message;
    @NotNull
    private final List<String> _signatures;
    private byte[] serializedMessage;

    public Transaction(@NotNull Message message, @NotNull List<String> _signatures) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(_signatures, (String)"_signatures");
        this.message = message;
        this._signatures = _signatures;
    }

    public /* synthetic */ Transaction(Message message, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            message = new Message(null, null, null, null, 15, null);
        }
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        this(message, list);
    }

    @NotNull
    public final Message getMessage() {
        return this.message;
    }

    @NotNull
    public final List<String> getSignatures() {
        return this._signatures;
    }

    @NotNull
    public final Transaction addInstruction(@NotNull TransactionInstruction instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        this.message.addInstruction(instruction);
        return this;
    }

    @NotNull
    public final Transaction setRecentBlockHash(@NotNull String recentBlockhash) {
        Intrinsics.checkNotNullParameter((Object)recentBlockhash, (String)"recentBlockhash");
        this.message.setRecentBlockHash(recentBlockhash);
        return this;
    }

    @NotNull
    public final Transaction setFeePayer(@Nullable PublicKey feePayer) {
        this.message.setFeePayer(feePayer);
        return this;
    }

    @NotNull
    public final Transaction sign(@NotNull Ed25519Keypair signer) {
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        return this.sign(CollectionsKt.listOf((Object)signer));
    }

    @NotNull
    public final Transaction sign(@NotNull List<Ed25519Keypair> signers) {
        Intrinsics.checkNotNullParameter(signers, (String)"signers");
        if (!(!((Collection)signers).isEmpty())) {
            boolean $i$a$-require-Transaction$sign$22 = false;
            String $i$a$-require-Transaction$sign$22 = "No signers";
            throw new IllegalArgumentException($i$a$-require-Transaction$sign$22.toString());
        }
        PublicKey publicKey = this.message.getFeePayer();
        if (publicKey == null) {
            Transaction it = this;
            boolean bl = false;
            this.message.setFeePayer(signers.get(0).getPublicKey());
            publicKey = Unit.INSTANCE;
        }
        this.serializedMessage = this.message.serialize();
        for (Ed25519Keypair signer : signers) {
            byte[] byArray = this.serializedMessage;
            if (this.serializedMessage == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"serializedMessage");
                byArray = null;
            }
            this._signatures.add(Base58Kt.encodeToBase58String((byte[])TweetNaCl.Signature.Companion.sign(byArray, signer.getSecretKey())));
        }
        return this;
    }

    @NotNull
    public final byte[] serialize() {
        int signaturesSize = this.getSignatures().size();
        byte[] signaturesLength = ShortvecEncoding.INSTANCE.encodeLength$solana_kotlin(signaturesSize);
        int n = signaturesLength.length + signaturesSize * 64;
        byte[] byArray = this.serializedMessage;
        if (this.serializedMessage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serializedMessage");
            byArray = null;
        }
        int bufferSize = n + byArray.length;
        Buffer out = new Buffer();
        out.write(signaturesLength);
        for (String signature : this.getSignatures()) {
            byte[] rawSignature = Base58Kt.decodeBase58((String)signature);
            out.write(rawSignature);
        }
        byte[] byArray2 = this.serializedMessage;
        if (this.serializedMessage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serializedMessage");
            byArray2 = null;
        }
        out.write(byArray2);
        return out.readByteArray((long)bufferSize);
    }

    @NotNull
    public String toString() {
        return StringsKt.trimMargin$default((String)("Transaction(\n            |  signatures: [" + CollectionsKt.joinToString$default((Iterable)this.getSignatures(), null, null, null, (int)0, null, null, (int)63, null) + "],\n            |  message: " + this.message + "\n        |)"), null, (int)1, null);
    }

    public Transaction() {
        this(null, null, 3, null);
    }
}

