/*
 * Decompiled with CFR 0.152.
 */
package net.avianlabs.solana.domain.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.avianlabs.solana.domain.core.AccountKeysList;
import net.avianlabs.solana.domain.core.AccountMeta;
import net.avianlabs.solana.domain.core.TransactionInstruction;
import net.avianlabs.solana.tweetnacl.ed25519.PublicKey;
import net.avianlabs.solana.tweetnacl.vendor.Base58Kt;
import net.avianlabs.solana.vendor.ShortvecEncoding;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002%&B7\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0002J\u001e\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u0005H\u0016R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u000f0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lnet/avianlabs/solana/domain/core/Message;", "", "feePayer", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "recentBlockHash", "", "accountKeys", "Lnet/avianlabs/solana/domain/core/AccountKeysList;", "instructions", "", "Lnet/avianlabs/solana/domain/core/TransactionInstruction;", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Ljava/lang/String;Lnet/avianlabs/solana/domain/core/AccountKeysList;Ljava/util/List;)V", "_accountKeys", "_instructions", "", "Lnet/avianlabs/solana/domain/core/AccountMeta;", "getAccountKeys", "()Ljava/util/List;", "getFeePayer", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "setFeePayer", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;)V", "getInstructions", "getRecentBlockHash", "()Ljava/lang/String;", "setRecentBlockHash", "(Ljava/lang/String;)V", "addInstruction", "instruction", "compileAccountKeys", "findAccountIndex", "", "accountMetaList", "key", "serialize", "", "toString", "CompiledInstruction", "MessageHeader", "solana-kotlin"})
@SourceDebugExtension(value={"SMAP\nMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Message.kt\nnet/avianlabs/solana/domain/core/Message\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class Message {
    @Nullable
    private PublicKey feePayer;
    @Nullable
    private String recentBlockHash;
    @NotNull
    private final AccountKeysList _accountKeys;
    @NotNull
    private final List<TransactionInstruction> _instructions;

    public Message(@Nullable PublicKey feePayer, @Nullable String recentBlockHash, @NotNull AccountKeysList accountKeys, @NotNull List<TransactionInstruction> instructions) {
        Intrinsics.checkNotNullParameter((Object)accountKeys, (String)"accountKeys");
        Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
        this.feePayer = feePayer;
        this.recentBlockHash = recentBlockHash;
        this._accountKeys = accountKeys;
        this._instructions = CollectionsKt.toMutableList((Collection)instructions);
    }

    public /* synthetic */ Message(PublicKey publicKey, String string, AccountKeysList accountKeysList, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            publicKey = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            accountKeysList = new AccountKeysList();
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(publicKey, string, accountKeysList, list);
    }

    @Nullable
    public final PublicKey getFeePayer() {
        return this.feePayer;
    }

    public final void setFeePayer(@Nullable PublicKey publicKey) {
        this.feePayer = publicKey;
    }

    @Nullable
    public final String getRecentBlockHash() {
        return this.recentBlockHash;
    }

    public final void setRecentBlockHash(@Nullable String string) {
        this.recentBlockHash = string;
    }

    @NotNull
    public final List<AccountMeta> getAccountKeys() {
        return this._accountKeys.getList();
    }

    @NotNull
    public final List<TransactionInstruction> getInstructions() {
        return this._instructions;
    }

    @NotNull
    public final Message addInstruction(@NotNull TransactionInstruction instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        this._accountKeys.addAll((Collection<AccountMeta>)instruction.getKeys());
        this._accountKeys.add(new AccountMeta(instruction.getProgramId(), false, false));
        this._instructions.add(instruction);
        return this;
    }

    @NotNull
    public final byte[] serialize() {
        if (this.recentBlockHash == null) {
            boolean $i$a$-requireNotNull-Message$serialize$22 = false;
            String $i$a$-requireNotNull-Message$serialize$22 = "recentBlockhash required";
            throw new IllegalArgumentException($i$a$-requireNotNull-Message$serialize$22.toString());
        }
        if (!(this._instructions.size() != 0)) {
            boolean $i$a$-require-Message$serialize$32 = false;
            String $i$a$-require-Message$serialize$32 = "No instructions provided";
            throw new IllegalArgumentException($i$a$-require-Message$serialize$32.toString());
        }
        MessageHeader messageHeader = new MessageHeader();
        List<AccountMeta> keysList = this.compileAccountKeys();
        int accountKeysSize = keysList.size();
        byte[] accountAddressesLength = ShortvecEncoding.INSTANCE.encodeLength$solana_kotlin(accountKeysSize);
        int compiledInstructionsLength = 0;
        List compiledInstructions = new ArrayList();
        for (TransactionInstruction instruction : this._instructions) {
            int keysSize = instruction.getKeys().size();
            byte[] keyIndices = new byte[keysSize];
            for (int i = 0; i < keysSize; ++i) {
                keyIndices[i] = (byte)this.findAccountIndex(keysList, instruction.getKeys().get(i).getPublicKey());
            }
            CompiledInstruction compiledInstruction = new CompiledInstruction();
            compiledInstruction.setProgramIdIndex((byte)this.findAccountIndex(keysList, instruction.getProgramId()));
            compiledInstruction.setKeyIndicesCount(ShortvecEncoding.INSTANCE.encodeLength$solana_kotlin(keysSize));
            compiledInstruction.setKeyIndices(keyIndices);
            compiledInstruction.setDataLength(ShortvecEncoding.INSTANCE.encodeLength$solana_kotlin(instruction.getData().length));
            compiledInstruction.setData(instruction.getData());
            compiledInstructions.add(compiledInstruction);
            compiledInstructionsLength += compiledInstruction.getLength();
        }
        byte[] instructionsLength = ShortvecEncoding.INSTANCE.encodeLength$solana_kotlin(compiledInstructions.size());
        int accountsKeyBufferSize = accountKeysSize * 32;
        int bufferSize = 35 + accountAddressesLength.length + accountsKeyBufferSize + instructionsLength.length + compiledInstructionsLength;
        Buffer out = new Buffer();
        Buffer accountKeysBuff = new Buffer();
        for (AccountMeta accountMeta : keysList) {
            accountKeysBuff.write(accountMeta.getPublicKey().toByteArray());
            if (accountMeta.isSigner()) {
                messageHeader.setNumRequiredSignatures((byte)(messageHeader.getNumRequiredSignatures() + 1));
                if (accountMeta.isWritable()) continue;
                messageHeader.setNumReadonlySignedAccounts((byte)(messageHeader.getNumReadonlySignedAccounts() + 1));
                continue;
            }
            if (accountMeta.isWritable()) continue;
            messageHeader.setNumReadonlyUnsignedAccounts((byte)(messageHeader.getNumReadonlyUnsignedAccounts() + 1));
        }
        out.write(messageHeader.toByteArray());
        out.write(accountAddressesLength);
        out.write(accountKeysBuff, (long)accountsKeyBufferSize);
        String string = this.recentBlockHash;
        Intrinsics.checkNotNull((Object)string);
        out.write(Base58Kt.decodeBase58((String)string));
        out.write(instructionsLength);
        for (CompiledInstruction compiledInstruction : compiledInstructions) {
            out.writeByte((int)compiledInstruction.getProgramIdIndex());
            out.write(compiledInstruction.getKeyIndicesCount());
            out.write(compiledInstruction.getKeyIndices());
            out.write(compiledInstruction.getDataLength());
            out.write(compiledInstruction.getData());
        }
        return out.readByteArray((long)bufferSize);
    }

    private final List<AccountMeta> compileAccountKeys() {
        List keysList = this._accountKeys.getList();
        List newList = new ArrayList();
        try {
            PublicKey publicKey = this.feePayer;
            Intrinsics.checkNotNull((Object)publicKey);
            int feePayerIndex = this.findAccountIndex(keysList, publicKey);
            AccountMeta feePayerMeta = (AccountMeta)keysList.get(feePayerIndex);
            newList.add(new AccountMeta(feePayerMeta.getPublicKey(), true, true));
            keysList.remove(feePayerIndex);
        }
        catch (RuntimeException e) {
            PublicKey publicKey = this.feePayer;
            Intrinsics.checkNotNull((Object)publicKey);
            newList.add(new AccountMeta(publicKey, true, true));
        }
        newList.addAll(keysList);
        return newList;
    }

    private final int findAccountIndex(List<AccountMeta> accountMetaList, PublicKey key) {
        int n = accountMetaList.size();
        for (int i = 0; i < n; ++i) {
            if (!accountMetaList.get(i).getPublicKey().equals((Object)key)) continue;
            return i;
        }
        throw new RuntimeException("unable to find account index");
    }

    @NotNull
    public String toString() {
        return StringsKt.trimMargin$default((String)("Message(\n          |  header: not set,\n          |  accountKeys: [" + CollectionsKt.joinToString$default((Iterable)this._accountKeys.getList(), null, null, null, (int)0, null, null, (int)63, null) + "],\n          |  recentBlockhash: " + this.recentBlockHash + ",\n          |  instructions: [" + CollectionsKt.joinToString$default((Iterable)this._instructions, null, null, null, (int)0, null, null, (int)63, null) + "]\n      |)"), null, (int)1, null);
    }

    public Message() {
        this(null, null, null, null, 15, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lnet/avianlabs/solana/domain/core/Message$CompiledInstruction;", "", "()V", "data", "", "getData", "()[B", "setData", "([B)V", "dataLength", "getDataLength", "setDataLength", "keyIndices", "getKeyIndices", "setKeyIndices", "keyIndicesCount", "getKeyIndicesCount", "setKeyIndicesCount", "length", "", "getLength", "()I", "programIdIndex", "", "getProgramIdIndex", "()B", "setProgramIdIndex", "(B)V", "solana-kotlin"})
    private static final class CompiledInstruction {
        private byte programIdIndex;
        public byte[] keyIndicesCount;
        public byte[] keyIndices;
        public byte[] dataLength;
        public byte[] data;

        public final byte getProgramIdIndex() {
            return this.programIdIndex;
        }

        public final void setProgramIdIndex(byte by) {
            this.programIdIndex = by;
        }

        @NotNull
        public final byte[] getKeyIndicesCount() {
            if (this.keyIndicesCount != null) {
                return this.keyIndicesCount;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"keyIndicesCount");
            return null;
        }

        public final void setKeyIndicesCount(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.keyIndicesCount = byArray;
        }

        @NotNull
        public final byte[] getKeyIndices() {
            if (this.keyIndices != null) {
                return this.keyIndices;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"keyIndices");
            return null;
        }

        public final void setKeyIndices(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.keyIndices = byArray;
        }

        @NotNull
        public final byte[] getDataLength() {
            if (this.dataLength != null) {
                return this.dataLength;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"dataLength");
            return null;
        }

        public final void setDataLength(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.dataLength = byArray;
        }

        @NotNull
        public final byte[] getData() {
            if (this.data != null) {
                return this.data;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
            return null;
        }

        public final void setData(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.data = byArray;
        }

        public final int getLength() {
            return 1 + this.getKeyIndicesCount().length + this.getKeyIndices().length + this.getDataLength().length + this.getData().length;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\b\u00a8\u0006\u0014"}, d2={"Lnet/avianlabs/solana/domain/core/Message$MessageHeader;", "", "()V", "numReadonlySignedAccounts", "", "getNumReadonlySignedAccounts", "()B", "setNumReadonlySignedAccounts", "(B)V", "numReadonlyUnsignedAccounts", "getNumReadonlyUnsignedAccounts", "setNumReadonlyUnsignedAccounts", "numRequiredSignatures", "getNumRequiredSignatures", "setNumRequiredSignatures", "toByteArray", "", "toString", "", "Companion", "solana-kotlin"})
    private static final class MessageHeader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private byte numRequiredSignatures;
        private byte numReadonlySignedAccounts;
        private byte numReadonlyUnsignedAccounts;
        public static final int HEADER_LENGTH = 3;

        public final byte getNumRequiredSignatures() {
            return this.numRequiredSignatures;
        }

        public final void setNumRequiredSignatures(byte by) {
            this.numRequiredSignatures = by;
        }

        public final byte getNumReadonlySignedAccounts() {
            return this.numReadonlySignedAccounts;
        }

        public final void setNumReadonlySignedAccounts(byte by) {
            this.numReadonlySignedAccounts = by;
        }

        public final byte getNumReadonlyUnsignedAccounts() {
            return this.numReadonlyUnsignedAccounts;
        }

        public final void setNumReadonlyUnsignedAccounts(byte by) {
            this.numReadonlyUnsignedAccounts = by;
        }

        @NotNull
        public final byte[] toByteArray() {
            byte[] byArray = new byte[]{this.numRequiredSignatures, this.numReadonlySignedAccounts, this.numReadonlyUnsignedAccounts};
            return byArray;
        }

        @NotNull
        public String toString() {
            return "numRequiredSignatures: " + this.numRequiredSignatures + ", numReadOnlySignedAccounts: " + this.numReadonlySignedAccounts + ", numReadOnlyUnsignedAccounts: " + this.numReadonlyUnsignedAccounts;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/avianlabs/solana/domain/core/Message$MessageHeader$Companion;", "", "()V", "HEADER_LENGTH", "", "fromByteArray", "Lnet/avianlabs/solana/domain/core/Message$MessageHeader;", "bytes", "", "solana-kotlin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MessageHeader fromByteArray(@NotNull byte[] bytes) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                MessageHeader header = new MessageHeader();
                header.setNumRequiredSignatures(bytes[0]);
                header.setNumReadonlySignedAccounts(bytes[1]);
                header.setNumReadonlyUnsignedAccounts(bytes[2]);
                return header;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

