/*
 * Decompiled with CFR 0.152.
 */
package net.avianlabs.solana.domain.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.avianlabs.solana.domain.core.AccountMeta;
import net.avianlabs.solana.domain.core.DecodedInstruction;
import net.avianlabs.solana.domain.core.DecodedTransaction;
import net.avianlabs.solana.domain.core.SignaturePublicKeyPair;
import net.avianlabs.solana.domain.program.AssociatedTokenProgram;
import net.avianlabs.solana.domain.program.SystemProgram;
import net.avianlabs.solana.domain.program.TokenProgram;
import net.avianlabs.solana.methods.TransactionResponse;
import net.avianlabs.solana.tweetnacl.ed25519.PublicKey;
import net.avianlabs.solana.tweetnacl.vendor.Base58Kt;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\f\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\n\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"defaultSignature", "", "decode", "Lnet/avianlabs/solana/domain/core/DecodedTransaction;", "Lnet/avianlabs/solana/methods/TransactionResponse;", "isAccountSigner", "", "Lnet/avianlabs/solana/methods/TransactionResponse$Message;", "index", "", "isAccountWritable", "solana-kotlin"})
@SourceDebugExtension(value={"SMAP\nDecodedTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecodedTransaction.kt\nnet/avianlabs/solana/domain/core/DecodedTransactionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1549#2:325\n1620#2,3:326\n1559#2:329\n1590#2,4:330\n1549#2:334\n1620#2,2:335\n1549#2:337\n1620#2,2:338\n1622#2:341\n1622#2:342\n1#3:340\n*S KotlinDebug\n*F\n+ 1 DecodedTransaction.kt\nnet/avianlabs/solana/domain/core/DecodedTransactionKt\n*L\n179#1:325\n179#1:326,3\n180#1:329\n180#1:330,4\n186#1:334\n186#1:335,2\n188#1:337\n188#1:338,2\n188#1:341\n186#1:342\n*E\n"})
public final class DecodedTransactionKt {
    @NotNull
    private static final String defaultSignature;

    private static final boolean isAccountWritable(TransactionResponse.Message $this$isAccountWritable, int index) {
        return (long)index < $this$isAccountWritable.getHeader().getNumRequiredSignatures() - $this$isAccountWritable.getHeader().getNumReadonlySignedAccounts() || (long)index >= $this$isAccountWritable.getHeader().getNumRequiredSignatures() && (long)index < (long)$this$isAccountWritable.getAccountKeys().size() - $this$isAccountWritable.getHeader().getNumReadonlyUnsignedAccounts();
    }

    private static final boolean isAccountSigner(TransactionResponse.Message $this$isAccountSigner, int index) {
        return (long)index < $this$isAccountSigner.getHeader().getNumRequiredSignatures();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final DecodedTransaction decode(@NotNull TransactionResponse $this$decode) {
        void $this$mapTo$iv$iv;
        void $this$mapIndexedTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$decode, (String)"<this>");
        Object object = $this$decode.getTransaction();
        if (object == null || (object = ((TransactionResponse.Transaction)object).getMessage()) == null) {
            return null;
        }
        Object message = object;
        Iterable $this$map$iv = $this$decode.getTransaction().getMessage().getAccountKeys();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Iterator iterator = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PublicKey.Companion.fromBase58((String)it));
        }
        List accounts = (List)destination$iv$iv;
        Iterable $this$mapIndexed$iv = $this$decode.getTransaction().getSignatures();
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void signature;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new SignaturePublicKeyPair(Intrinsics.areEqual((Object)signature, (Object)defaultSignature) ? null : Base58Kt.decodeBase58((String)signature), (PublicKey)accounts.get((int)index)));
        }
        List signatures = (List)destination$iv$iv2;
        Iterable $this$map$iv2 = ((TransactionResponse.Message)message).getInstructions();
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DecodedInstruction decodedInstruction;
            List list;
            PublicKey publicKey;
            Iterable iterable2;
            Iterator iterator;
            int $i$f$mapTo3;
            Iterable iterable3;
            void instruction;
            TransactionResponse.Instruction instruction2 = (TransactionResponse.Instruction)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            PublicKey programKey = (PublicKey)accounts.get((int)instruction.getProgramIdIndex());
            List<Long> list2 = instruction.getAccounts();
            if (list2 != null) {
                void $this$mapTo$iv$iv3;
                Iterable $this$map$iv3 = list2;
                boolean $i$f$map3 = false;
                iterable3 = $this$map$iv3;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                $i$f$mapTo3 = 0;
                iterator = $this$mapTo$iv$iv3.iterator();
                while (iterator.hasNext()) {
                    Object v2;
                    int index;
                    Collection collection2;
                    block31: {
                        void it;
                        Object item$iv$iv2 = iterator.next();
                        long l = ((Number)item$iv$iv2).longValue();
                        collection2 = destination$iv$iv4;
                        boolean bl2 = false;
                        index = (int)it;
                        PublicKey publicKey2 = (PublicKey)accounts.get(index);
                        iterable2 = signatures;
                        publicKey = publicKey2;
                        Iterable iterable4 = iterable2;
                        for (Object t : iterable4) {
                            SignaturePublicKeyPair it2 = (SignaturePublicKeyPair)t;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it2.getPublicKey(), (Object)publicKey2)) continue;
                            v2 = t;
                            break block31;
                        }
                        v2 = null;
                    }
                    boolean bl4 = DecodedTransactionKt.isAccountWritable((TransactionResponse.Message)message, index);
                    boolean bl5 = v2 != null || DecodedTransactionKt.isAccountSigner((TransactionResponse.Message)message, index);
                    PublicKey publicKey3 = publicKey;
                    collection2.add(new AccountMeta(publicKey3, bl5, bl4));
                }
                list = (List)destination$iv$iv4;
            } else {
                list = null;
            }
            List accountsMeta = list;
            String string = instruction.getData();
            Intrinsics.checkNotNull((Object)string);
            byte[] data = Base58Kt.decodeBase58((String)string);
            Buffer buffer = new Buffer().write(data);
            DecodedInstruction.Raw raw = new DecodedInstruction.Raw(programKey, accountsMeta, data);
            iterable3 = programKey;
            if (Intrinsics.areEqual((Object)iterable3, (Object)SystemProgram.INSTANCE.getProgramId())) {
                int programIndex = UInt.constructor-impl((int)buffer.readInt());
                $i$f$mapTo3 = programIndex;
                if ($i$f$mapTo3 == SystemProgram.Instruction.Transfer.getIndex-pVg5ArA()) {
                    Intrinsics.checkNotNull((Object)accountsMeta);
                    from = (AccountMeta)iterator.get(0);
                    AccountMeta to = (AccountMeta)iterator.get(1);
                    decodedInstruction = new DecodedInstruction.SystemProgram.Transfer(from.getPublicKey(), to.getPublicKey(), buffer.readLongLe());
                } else if ($i$f$mapTo3 == SystemProgram.Instruction.AdvanceNonceAccount.getIndex-pVg5ArA()) {
                    Intrinsics.checkNotNull((Object)accountsMeta);
                    nonceAccount = (AccountMeta)iterator.get(0);
                    authorizedPubkey = (AccountMeta)iterator.get(1);
                    decodedInstruction = new DecodedInstruction.SystemProgram.AdvanceNonceAccount(nonceAccount.getPublicKey(), authorizedPubkey.getPublicKey());
                } else if ($i$f$mapTo3 == SystemProgram.Instruction.AuthorizeNonceAccount.getIndex-pVg5ArA()) {
                    Intrinsics.checkNotNull((Object)accountsMeta);
                    nonceAccount = (AccountMeta)iterator.get(0);
                    authorizedPubkey = (AccountMeta)iterator.get(1);
                    AccountMeta newAuthorizedPubkey = (AccountMeta)iterator.get(2);
                    decodedInstruction = new DecodedInstruction.SystemProgram.AuthorizeNonceAccount(nonceAccount.getPublicKey(), authorizedPubkey.getPublicKey(), newAuthorizedPubkey.getPublicKey());
                } else if ($i$f$mapTo3 == SystemProgram.Instruction.CreateAccount.getIndex-pVg5ArA()) {
                    Intrinsics.checkNotNull((Object)accountsMeta);
                    from = (AccountMeta)iterator.get(0);
                    AccountMeta newAccount = (AccountMeta)iterator.get(1);
                    owner = (AccountMeta)iterator.get(2);
                    decodedInstruction = new DecodedInstruction.SystemProgram.CreateAccount(from.getPublicKey(), newAccount.getPublicKey(), buffer.readLongLe(), buffer.readLongLe(), owner.getPublicKey());
                } else if ($i$f$mapTo3 == SystemProgram.Instruction.InitializeNonceAccount.getIndex-pVg5ArA()) {
                    Intrinsics.checkNotNull((Object)accountsMeta);
                    nonceAccount = (AccountMeta)iterator.get(0);
                    authorizedPubkey = (AccountMeta)iterator.get(1);
                    decodedInstruction = new DecodedInstruction.SystemProgram.InitializeNonceAccount(nonceAccount.getPublicKey(), authorizedPubkey.getPublicKey());
                } else if ($i$f$mapTo3 == SystemProgram.Instruction.WithdrawNonceAccount.getIndex-pVg5ArA()) {
                    Intrinsics.checkNotNull((Object)accountsMeta);
                    nonceAccount = (AccountMeta)iterator.get(0);
                    authorizedPubkey = (AccountMeta)iterator.get(1);
                    destination = (AccountMeta)iterator.get(2);
                    decodedInstruction = new DecodedInstruction.SystemProgram.WithdrawNonceAccount(nonceAccount.getPublicKey(), authorizedPubkey.getPublicKey(), destination.getPublicKey(), buffer.readLongLe());
                } else {
                    decodedInstruction = raw;
                }
            } else if (Intrinsics.areEqual((Object)iterable3, (Object)TokenProgram.Companion.getProgramId())) {
                byte programIndex = UByte.constructor-impl((byte)buffer.readByte());
                $i$f$mapTo3 = programIndex;
                if ($i$f$mapTo3 == TokenProgram.Instruction.Transfer.getIndex-w2LRezQ()) {
                    Intrinsics.checkNotNull((Object)accountsMeta);
                    source = (AccountMeta)iterator.get(0);
                    AccountMeta destination = (AccountMeta)iterator.get(1);
                    owner = (AccountMeta)iterator.get(2);
                    decodedInstruction = new DecodedInstruction.TokenProgram.Transfer(source.getPublicKey(), destination.getPublicKey(), owner.getPublicKey(), buffer.readLongLe());
                } else if ($i$f$mapTo3 == TokenProgram.Instruction.TransferChecked.getIndex-w2LRezQ()) {
                    Intrinsics.checkNotNull((Object)accountsMeta);
                    source = (AccountMeta)iterator.get(0);
                    mint = (AccountMeta)iterator.get(1);
                    destination = (AccountMeta)iterator.get(2);
                    AccountMeta owner = (AccountMeta)iterator.get(3);
                    PublicKey publicKey4 = source.getPublicKey();
                    PublicKey publicKey5 = destination.getPublicKey();
                    iterable2 = mint.getPublicKey();
                    publicKey = owner.getPublicKey();
                    long l = buffer.readLongLe();
                    byte by = UByte.constructor-impl((byte)buffer.readByte());
                    decodedInstruction = new DecodedInstruction.TokenProgram.TransferChecked(publicKey4, (PublicKey)iterable2, publicKey5, publicKey, l, by, null);
                } else {
                    decodedInstruction = raw;
                }
            } else if (Intrinsics.areEqual((Object)iterable3, (Object)AssociatedTokenProgram.INSTANCE.getProgramId())) {
                List list3;
                Intrinsics.checkNotNull((Object)accountsMeta);
                AccountMeta payer = (AccountMeta)list3.get(0);
                AccountMeta associatedAccount = (AccountMeta)list3.get(1);
                AccountMeta owner = (AccountMeta)list3.get(2);
                mint = (AccountMeta)list3.get(3);
                AccountMeta programId = (AccountMeta)list3.get(4);
                decodedInstruction = new DecodedInstruction.AssociatedTokenProgram.CreatedAssociatedAccount(payer.getPublicKey(), associatedAccount.getPublicKey(), owner.getPublicKey(), mint.getPublicKey(), programId.getPublicKey());
            } else {
                decodedInstruction = raw;
            }
            collection.add(decodedInstruction);
        }
        List instructions = (List)destination$iv$iv3;
        return new DecodedTransaction(instructions, signatures);
    }

    static {
        int n = 0;
        byte[] byArray = new byte[64];
        while (n < 64) {
            int n2 = n++;
            byArray[n2] = 0;
        }
        defaultSignature = Base58Kt.encodeToBase58String((byte[])byArray);
    }
}

