/*
 * Decompiled with CFR 0.152.
 */
package net.avianlabs.solana.domain.core;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.avianlabs.solana.domain.core.AccountMeta;
import net.avianlabs.solana.domain.program.SystemProgram;
import net.avianlabs.solana.domain.program.TokenProgram;
import net.avianlabs.solana.tweetnacl.ed25519.PublicKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction;", "", "program", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;)V", "getProgram", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "AssociatedTokenProgram", "Raw", "SystemProgram", "TokenProgram", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$AssociatedTokenProgram;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$Raw;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$TokenProgram;", "solana-kotlin"})
public abstract class DecodedInstruction {
    @NotNull
    private final PublicKey program;

    private DecodedInstruction(PublicKey program) {
        this.program = program;
    }

    @NotNull
    public PublicKey getProgram() {
        return this.program;
    }

    public /* synthetic */ DecodedInstruction(PublicKey program, DefaultConstructorMarker $constructor_marker) {
        this(program);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0001\u0004\u00a8\u0006\u0005"}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction$AssociatedTokenProgram;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction;", "()V", "CreatedAssociatedAccount", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$AssociatedTokenProgram$CreatedAssociatedAccount;", "solana-kotlin"})
    public static abstract class AssociatedTokenProgram
    extends DecodedInstruction {
        private AssociatedTokenProgram() {
            super(net.avianlabs.solana.domain.program.AssociatedTokenProgram.INSTANCE.getProgramId(), null);
        }

        public /* synthetic */ AssociatedTokenProgram(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001d"}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction$AssociatedTokenProgram$CreatedAssociatedAccount;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$AssociatedTokenProgram;", "payer", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "associatedAccount", "owner", "mint", "programId", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;)V", "getAssociatedAccount", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "getMint", "getOwner", "getPayer", "getProgramId", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "solana-kotlin"})
        public static final class CreatedAssociatedAccount
        extends AssociatedTokenProgram {
            @NotNull
            private final PublicKey payer;
            @NotNull
            private final PublicKey associatedAccount;
            @NotNull
            private final PublicKey owner;
            @NotNull
            private final PublicKey mint;
            @NotNull
            private final PublicKey programId;

            public CreatedAssociatedAccount(@NotNull PublicKey payer, @NotNull PublicKey associatedAccount, @NotNull PublicKey owner, @NotNull PublicKey mint, @NotNull PublicKey programId) {
                Intrinsics.checkNotNullParameter((Object)payer, (String)"payer");
                Intrinsics.checkNotNullParameter((Object)associatedAccount, (String)"associatedAccount");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)mint, (String)"mint");
                Intrinsics.checkNotNullParameter((Object)programId, (String)"programId");
                super((DefaultConstructorMarker)null);
                this.payer = payer;
                this.associatedAccount = associatedAccount;
                this.owner = owner;
                this.mint = mint;
                this.programId = programId;
            }

            @NotNull
            public final PublicKey getPayer() {
                return this.payer;
            }

            @NotNull
            public final PublicKey getAssociatedAccount() {
                return this.associatedAccount;
            }

            @NotNull
            public final PublicKey getOwner() {
                return this.owner;
            }

            @NotNull
            public final PublicKey getMint() {
                return this.mint;
            }

            @NotNull
            public final PublicKey getProgramId() {
                return this.programId;
            }

            @NotNull
            public final PublicKey component1() {
                return this.payer;
            }

            @NotNull
            public final PublicKey component2() {
                return this.associatedAccount;
            }

            @NotNull
            public final PublicKey component3() {
                return this.owner;
            }

            @NotNull
            public final PublicKey component4() {
                return this.mint;
            }

            @NotNull
            public final PublicKey component5() {
                return this.programId;
            }

            @NotNull
            public final CreatedAssociatedAccount copy(@NotNull PublicKey payer, @NotNull PublicKey associatedAccount, @NotNull PublicKey owner, @NotNull PublicKey mint, @NotNull PublicKey programId) {
                Intrinsics.checkNotNullParameter((Object)payer, (String)"payer");
                Intrinsics.checkNotNullParameter((Object)associatedAccount, (String)"associatedAccount");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)mint, (String)"mint");
                Intrinsics.checkNotNullParameter((Object)programId, (String)"programId");
                return new CreatedAssociatedAccount(payer, associatedAccount, owner, mint, programId);
            }

            public static /* synthetic */ CreatedAssociatedAccount copy$default(CreatedAssociatedAccount createdAssociatedAccount, PublicKey publicKey, PublicKey publicKey2, PublicKey publicKey3, PublicKey publicKey4, PublicKey publicKey5, int n, Object object) {
                if ((n & 1) != 0) {
                    publicKey = createdAssociatedAccount.payer;
                }
                if ((n & 2) != 0) {
                    publicKey2 = createdAssociatedAccount.associatedAccount;
                }
                if ((n & 4) != 0) {
                    publicKey3 = createdAssociatedAccount.owner;
                }
                if ((n & 8) != 0) {
                    publicKey4 = createdAssociatedAccount.mint;
                }
                if ((n & 0x10) != 0) {
                    publicKey5 = createdAssociatedAccount.programId;
                }
                return createdAssociatedAccount.copy(publicKey, publicKey2, publicKey3, publicKey4, publicKey5);
            }

            @NotNull
            public String toString() {
                return "CreatedAssociatedAccount(payer=" + this.payer + ", associatedAccount=" + this.associatedAccount + ", owner=" + this.owner + ", mint=" + this.mint + ", programId=" + this.programId + ")";
            }

            public int hashCode() {
                int result2 = this.payer.hashCode();
                result2 = result2 * 31 + this.associatedAccount.hashCode();
                result2 = result2 * 31 + this.owner.hashCode();
                result2 = result2 * 31 + this.mint.hashCode();
                result2 = result2 * 31 + this.programId.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CreatedAssociatedAccount)) {
                    return false;
                }
                CreatedAssociatedAccount createdAssociatedAccount = (CreatedAssociatedAccount)other;
                if (!Intrinsics.areEqual((Object)this.payer, (Object)createdAssociatedAccount.payer)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.associatedAccount, (Object)createdAssociatedAccount.associatedAccount)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.owner, (Object)createdAssociatedAccount.owner)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.mint, (Object)createdAssociatedAccount.mint)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.programId, (Object)createdAssociatedAccount.programId);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction$Raw;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction;", "program", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "accounts", "", "Lnet/avianlabs/solana/domain/core/AccountMeta;", "data", "", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Ljava/util/List;[B)V", "getAccounts", "()Ljava/util/List;", "getData", "()[B", "getProgram", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "solana-kotlin"})
    public static final class Raw
    extends DecodedInstruction {
        @NotNull
        private final PublicKey program;
        @Nullable
        private final List<AccountMeta> accounts;
        @Nullable
        private final byte[] data;

        public Raw(@NotNull PublicKey program, @Nullable List<AccountMeta> accounts, @Nullable byte[] data) {
            Intrinsics.checkNotNullParameter((Object)program, (String)"program");
            super(program, null);
            this.program = program;
            this.accounts = accounts;
            this.data = data;
        }

        @Override
        @NotNull
        public PublicKey getProgram() {
            return this.program;
        }

        @Nullable
        public final List<AccountMeta> getAccounts() {
            return this.accounts;
        }

        @Nullable
        public final byte[] getData() {
            return this.data;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Raw cfr_ignored_0 = (Raw)other;
            if (!Intrinsics.areEqual((Object)this.getProgram(), (Object)((Raw)other).getProgram())) {
                return false;
            }
            if (!Intrinsics.areEqual(this.accounts, ((Raw)other).accounts)) {
                return false;
            }
            if (this.data != null) {
                if (((Raw)other).data == null) {
                    return false;
                }
                if (!Arrays.equals(this.data, ((Raw)other).data)) {
                    return false;
                }
            } else if (((Raw)other).data != null) {
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result2 = this.getProgram().hashCode();
            List<AccountMeta> list = this.accounts;
            result2 = 31 * result2 + (list != null ? ((Object)list).hashCode() : 0);
            result2 = 31 * result2 + (this.data != null ? Arrays.hashCode(this.data) : 0);
            return result2;
        }

        @NotNull
        public final PublicKey component1() {
            return this.program;
        }

        @Nullable
        public final List<AccountMeta> component2() {
            return this.accounts;
        }

        @Nullable
        public final byte[] component3() {
            return this.data;
        }

        @NotNull
        public final Raw copy(@NotNull PublicKey program, @Nullable List<AccountMeta> accounts, @Nullable byte[] data) {
            Intrinsics.checkNotNullParameter((Object)program, (String)"program");
            return new Raw(program, accounts, data);
        }

        public static /* synthetic */ Raw copy$default(Raw raw, PublicKey publicKey, List list, byte[] byArray, int n, Object object) {
            if ((n & 1) != 0) {
                publicKey = raw.program;
            }
            if ((n & 2) != 0) {
                list = raw.accounts;
            }
            if ((n & 4) != 0) {
                byArray = raw.data;
            }
            return raw.copy(publicKey, list, byArray);
        }

        @NotNull
        public String toString() {
            return "Raw(program=" + this.program + ", accounts=" + this.accounts + ", data=" + Arrays.toString(this.data) + ")";
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0006\b\t\n\u000b\f\rB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0019\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0006\u000e\u000f\u0010\u0011\u0012\u0013\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0014"}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction;", "programIndex", "Lkotlin/UInt;", "(I)V", "getProgramIndex-pVg5ArA", "()I", "I", "AdvanceNonceAccount", "AuthorizeNonceAccount", "CreateAccount", "InitializeNonceAccount", "Transfer", "WithdrawNonceAccount", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram$AdvanceNonceAccount;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram$AuthorizeNonceAccount;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram$CreateAccount;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram$InitializeNonceAccount;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram$Transfer;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram$WithdrawNonceAccount;", "solana-kotlin"})
    public static abstract class SystemProgram
    extends DecodedInstruction {
        private final int programIndex;

        private SystemProgram(int programIndex) {
            super(net.avianlabs.solana.domain.program.SystemProgram.INSTANCE.getProgramId(), null);
            this.programIndex = programIndex;
        }

        public final int getProgramIndex-pVg5ArA() {
            return this.programIndex;
        }

        public /* synthetic */ SystemProgram(int programIndex, DefaultConstructorMarker $constructor_marker) {
            this(programIndex);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram$AdvanceNonceAccount;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram;", "nonceAccount", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "authorizedPubkey", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;)V", "getAuthorizedPubkey", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "getNonceAccount", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "solana-kotlin"})
        public static final class AdvanceNonceAccount
        extends SystemProgram {
            @NotNull
            private final PublicKey nonceAccount;
            @NotNull
            private final PublicKey authorizedPubkey;

            public AdvanceNonceAccount(@NotNull PublicKey nonceAccount, @NotNull PublicKey authorizedPubkey) {
                Intrinsics.checkNotNullParameter((Object)nonceAccount, (String)"nonceAccount");
                Intrinsics.checkNotNullParameter((Object)authorizedPubkey, (String)"authorizedPubkey");
                super(SystemProgram.Instruction.AdvanceNonceAccount.getIndex-pVg5ArA(), null);
                this.nonceAccount = nonceAccount;
                this.authorizedPubkey = authorizedPubkey;
            }

            @NotNull
            public final PublicKey getNonceAccount() {
                return this.nonceAccount;
            }

            @NotNull
            public final PublicKey getAuthorizedPubkey() {
                return this.authorizedPubkey;
            }

            @NotNull
            public final PublicKey component1() {
                return this.nonceAccount;
            }

            @NotNull
            public final PublicKey component2() {
                return this.authorizedPubkey;
            }

            @NotNull
            public final AdvanceNonceAccount copy(@NotNull PublicKey nonceAccount, @NotNull PublicKey authorizedPubkey) {
                Intrinsics.checkNotNullParameter((Object)nonceAccount, (String)"nonceAccount");
                Intrinsics.checkNotNullParameter((Object)authorizedPubkey, (String)"authorizedPubkey");
                return new AdvanceNonceAccount(nonceAccount, authorizedPubkey);
            }

            public static /* synthetic */ AdvanceNonceAccount copy$default(AdvanceNonceAccount advanceNonceAccount, PublicKey publicKey, PublicKey publicKey2, int n, Object object) {
                if ((n & 1) != 0) {
                    publicKey = advanceNonceAccount.nonceAccount;
                }
                if ((n & 2) != 0) {
                    publicKey2 = advanceNonceAccount.authorizedPubkey;
                }
                return advanceNonceAccount.copy(publicKey, publicKey2);
            }

            @NotNull
            public String toString() {
                return "AdvanceNonceAccount(nonceAccount=" + this.nonceAccount + ", authorizedPubkey=" + this.authorizedPubkey + ")";
            }

            public int hashCode() {
                int result2 = this.nonceAccount.hashCode();
                result2 = result2 * 31 + this.authorizedPubkey.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AdvanceNonceAccount)) {
                    return false;
                }
                AdvanceNonceAccount advanceNonceAccount = (AdvanceNonceAccount)other;
                if (!Intrinsics.areEqual((Object)this.nonceAccount, (Object)advanceNonceAccount.nonceAccount)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.authorizedPubkey, (Object)advanceNonceAccount.authorizedPubkey);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram$AuthorizeNonceAccount;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram;", "nonceAccount", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "authorizedPubkey", "newAuthorizedPubkey", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;)V", "getAuthorizedPubkey", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "getNewAuthorizedPubkey", "getNonceAccount", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "solana-kotlin"})
        public static final class AuthorizeNonceAccount
        extends SystemProgram {
            @NotNull
            private final PublicKey nonceAccount;
            @NotNull
            private final PublicKey authorizedPubkey;
            @NotNull
            private final PublicKey newAuthorizedPubkey;

            public AuthorizeNonceAccount(@NotNull PublicKey nonceAccount, @NotNull PublicKey authorizedPubkey, @NotNull PublicKey newAuthorizedPubkey) {
                Intrinsics.checkNotNullParameter((Object)nonceAccount, (String)"nonceAccount");
                Intrinsics.checkNotNullParameter((Object)authorizedPubkey, (String)"authorizedPubkey");
                Intrinsics.checkNotNullParameter((Object)newAuthorizedPubkey, (String)"newAuthorizedPubkey");
                super(SystemProgram.Instruction.AuthorizeNonceAccount.getIndex-pVg5ArA(), null);
                this.nonceAccount = nonceAccount;
                this.authorizedPubkey = authorizedPubkey;
                this.newAuthorizedPubkey = newAuthorizedPubkey;
            }

            @NotNull
            public final PublicKey getNonceAccount() {
                return this.nonceAccount;
            }

            @NotNull
            public final PublicKey getAuthorizedPubkey() {
                return this.authorizedPubkey;
            }

            @NotNull
            public final PublicKey getNewAuthorizedPubkey() {
                return this.newAuthorizedPubkey;
            }

            @NotNull
            public final PublicKey component1() {
                return this.nonceAccount;
            }

            @NotNull
            public final PublicKey component2() {
                return this.authorizedPubkey;
            }

            @NotNull
            public final PublicKey component3() {
                return this.newAuthorizedPubkey;
            }

            @NotNull
            public final AuthorizeNonceAccount copy(@NotNull PublicKey nonceAccount, @NotNull PublicKey authorizedPubkey, @NotNull PublicKey newAuthorizedPubkey) {
                Intrinsics.checkNotNullParameter((Object)nonceAccount, (String)"nonceAccount");
                Intrinsics.checkNotNullParameter((Object)authorizedPubkey, (String)"authorizedPubkey");
                Intrinsics.checkNotNullParameter((Object)newAuthorizedPubkey, (String)"newAuthorizedPubkey");
                return new AuthorizeNonceAccount(nonceAccount, authorizedPubkey, newAuthorizedPubkey);
            }

            public static /* synthetic */ AuthorizeNonceAccount copy$default(AuthorizeNonceAccount authorizeNonceAccount, PublicKey publicKey, PublicKey publicKey2, PublicKey publicKey3, int n, Object object) {
                if ((n & 1) != 0) {
                    publicKey = authorizeNonceAccount.nonceAccount;
                }
                if ((n & 2) != 0) {
                    publicKey2 = authorizeNonceAccount.authorizedPubkey;
                }
                if ((n & 4) != 0) {
                    publicKey3 = authorizeNonceAccount.newAuthorizedPubkey;
                }
                return authorizeNonceAccount.copy(publicKey, publicKey2, publicKey3);
            }

            @NotNull
            public String toString() {
                return "AuthorizeNonceAccount(nonceAccount=" + this.nonceAccount + ", authorizedPubkey=" + this.authorizedPubkey + ", newAuthorizedPubkey=" + this.newAuthorizedPubkey + ")";
            }

            public int hashCode() {
                int result2 = this.nonceAccount.hashCode();
                result2 = result2 * 31 + this.authorizedPubkey.hashCode();
                result2 = result2 * 31 + this.newAuthorizedPubkey.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AuthorizeNonceAccount)) {
                    return false;
                }
                AuthorizeNonceAccount authorizeNonceAccount = (AuthorizeNonceAccount)other;
                if (!Intrinsics.areEqual((Object)this.nonceAccount, (Object)authorizeNonceAccount.nonceAccount)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.authorizedPubkey, (Object)authorizeNonceAccount.authorizedPubkey)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.newAuthorizedPubkey, (Object)authorizeNonceAccount.newAuthorizedPubkey);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001f"}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram$CreateAccount;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram;", "from", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "newAccount", "lamports", "", "space", "owner", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;JJLnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;)V", "getFrom", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "getLamports", "()J", "getNewAccount", "getOwner", "getSpace", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "solana-kotlin"})
        public static final class CreateAccount
        extends SystemProgram {
            @NotNull
            private final PublicKey from;
            @NotNull
            private final PublicKey newAccount;
            private final long lamports;
            private final long space;
            @NotNull
            private final PublicKey owner;

            public CreateAccount(@NotNull PublicKey from, @NotNull PublicKey newAccount, long lamports, long space, @NotNull PublicKey owner) {
                Intrinsics.checkNotNullParameter((Object)from, (String)"from");
                Intrinsics.checkNotNullParameter((Object)newAccount, (String)"newAccount");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                super(SystemProgram.Instruction.CreateAccount.getIndex-pVg5ArA(), null);
                this.from = from;
                this.newAccount = newAccount;
                this.lamports = lamports;
                this.space = space;
                this.owner = owner;
            }

            @NotNull
            public final PublicKey getFrom() {
                return this.from;
            }

            @NotNull
            public final PublicKey getNewAccount() {
                return this.newAccount;
            }

            public final long getLamports() {
                return this.lamports;
            }

            public final long getSpace() {
                return this.space;
            }

            @NotNull
            public final PublicKey getOwner() {
                return this.owner;
            }

            @NotNull
            public final PublicKey component1() {
                return this.from;
            }

            @NotNull
            public final PublicKey component2() {
                return this.newAccount;
            }

            public final long component3() {
                return this.lamports;
            }

            public final long component4() {
                return this.space;
            }

            @NotNull
            public final PublicKey component5() {
                return this.owner;
            }

            @NotNull
            public final CreateAccount copy(@NotNull PublicKey from, @NotNull PublicKey newAccount, long lamports, long space, @NotNull PublicKey owner) {
                Intrinsics.checkNotNullParameter((Object)from, (String)"from");
                Intrinsics.checkNotNullParameter((Object)newAccount, (String)"newAccount");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                return new CreateAccount(from, newAccount, lamports, space, owner);
            }

            public static /* synthetic */ CreateAccount copy$default(CreateAccount createAccount, PublicKey publicKey, PublicKey publicKey2, long l, long l2, PublicKey publicKey3, int n, Object object) {
                if ((n & 1) != 0) {
                    publicKey = createAccount.from;
                }
                if ((n & 2) != 0) {
                    publicKey2 = createAccount.newAccount;
                }
                if ((n & 4) != 0) {
                    l = createAccount.lamports;
                }
                if ((n & 8) != 0) {
                    l2 = createAccount.space;
                }
                if ((n & 0x10) != 0) {
                    publicKey3 = createAccount.owner;
                }
                return createAccount.copy(publicKey, publicKey2, l, l2, publicKey3);
            }

            @NotNull
            public String toString() {
                return "CreateAccount(from=" + this.from + ", newAccount=" + this.newAccount + ", lamports=" + this.lamports + ", space=" + this.space + ", owner=" + this.owner + ")";
            }

            public int hashCode() {
                int result2 = this.from.hashCode();
                result2 = result2 * 31 + this.newAccount.hashCode();
                result2 = result2 * 31 + Long.hashCode(this.lamports);
                result2 = result2 * 31 + Long.hashCode(this.space);
                result2 = result2 * 31 + this.owner.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CreateAccount)) {
                    return false;
                }
                CreateAccount createAccount = (CreateAccount)other;
                if (!Intrinsics.areEqual((Object)this.from, (Object)createAccount.from)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.newAccount, (Object)createAccount.newAccount)) {
                    return false;
                }
                if (this.lamports != createAccount.lamports) {
                    return false;
                }
                if (this.space != createAccount.space) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.owner, (Object)createAccount.owner);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram$InitializeNonceAccount;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram;", "nonceAccount", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "authorizedPubkey", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;)V", "getAuthorizedPubkey", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "getNonceAccount", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "solana-kotlin"})
        public static final class InitializeNonceAccount
        extends SystemProgram {
            @NotNull
            private final PublicKey nonceAccount;
            @NotNull
            private final PublicKey authorizedPubkey;

            public InitializeNonceAccount(@NotNull PublicKey nonceAccount, @NotNull PublicKey authorizedPubkey) {
                Intrinsics.checkNotNullParameter((Object)nonceAccount, (String)"nonceAccount");
                Intrinsics.checkNotNullParameter((Object)authorizedPubkey, (String)"authorizedPubkey");
                super(SystemProgram.Instruction.InitializeNonceAccount.getIndex-pVg5ArA(), null);
                this.nonceAccount = nonceAccount;
                this.authorizedPubkey = authorizedPubkey;
            }

            @NotNull
            public final PublicKey getNonceAccount() {
                return this.nonceAccount;
            }

            @NotNull
            public final PublicKey getAuthorizedPubkey() {
                return this.authorizedPubkey;
            }

            @NotNull
            public final PublicKey component1() {
                return this.nonceAccount;
            }

            @NotNull
            public final PublicKey component2() {
                return this.authorizedPubkey;
            }

            @NotNull
            public final InitializeNonceAccount copy(@NotNull PublicKey nonceAccount, @NotNull PublicKey authorizedPubkey) {
                Intrinsics.checkNotNullParameter((Object)nonceAccount, (String)"nonceAccount");
                Intrinsics.checkNotNullParameter((Object)authorizedPubkey, (String)"authorizedPubkey");
                return new InitializeNonceAccount(nonceAccount, authorizedPubkey);
            }

            public static /* synthetic */ InitializeNonceAccount copy$default(InitializeNonceAccount initializeNonceAccount, PublicKey publicKey, PublicKey publicKey2, int n, Object object) {
                if ((n & 1) != 0) {
                    publicKey = initializeNonceAccount.nonceAccount;
                }
                if ((n & 2) != 0) {
                    publicKey2 = initializeNonceAccount.authorizedPubkey;
                }
                return initializeNonceAccount.copy(publicKey, publicKey2);
            }

            @NotNull
            public String toString() {
                return "InitializeNonceAccount(nonceAccount=" + this.nonceAccount + ", authorizedPubkey=" + this.authorizedPubkey + ")";
            }

            public int hashCode() {
                int result2 = this.nonceAccount.hashCode();
                result2 = result2 * 31 + this.authorizedPubkey.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof InitializeNonceAccount)) {
                    return false;
                }
                InitializeNonceAccount initializeNonceAccount = (InitializeNonceAccount)other;
                if (!Intrinsics.areEqual((Object)this.nonceAccount, (Object)initializeNonceAccount.nonceAccount)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.authorizedPubkey, (Object)initializeNonceAccount.authorizedPubkey);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram$Transfer;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram;", "from", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "to", "lamports", "", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;J)V", "getFrom", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "getLamports", "()J", "getTo", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "solana-kotlin"})
        public static final class Transfer
        extends SystemProgram {
            @NotNull
            private final PublicKey from;
            @NotNull
            private final PublicKey to;
            private final long lamports;

            public Transfer(@NotNull PublicKey from, @NotNull PublicKey to, long lamports) {
                Intrinsics.checkNotNullParameter((Object)from, (String)"from");
                Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                super(SystemProgram.Instruction.Transfer.getIndex-pVg5ArA(), null);
                this.from = from;
                this.to = to;
                this.lamports = lamports;
            }

            @NotNull
            public final PublicKey getFrom() {
                return this.from;
            }

            @NotNull
            public final PublicKey getTo() {
                return this.to;
            }

            public final long getLamports() {
                return this.lamports;
            }

            @NotNull
            public final PublicKey component1() {
                return this.from;
            }

            @NotNull
            public final PublicKey component2() {
                return this.to;
            }

            public final long component3() {
                return this.lamports;
            }

            @NotNull
            public final Transfer copy(@NotNull PublicKey from, @NotNull PublicKey to, long lamports) {
                Intrinsics.checkNotNullParameter((Object)from, (String)"from");
                Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                return new Transfer(from, to, lamports);
            }

            public static /* synthetic */ Transfer copy$default(Transfer transfer, PublicKey publicKey, PublicKey publicKey2, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    publicKey = transfer.from;
                }
                if ((n & 2) != 0) {
                    publicKey2 = transfer.to;
                }
                if ((n & 4) != 0) {
                    l = transfer.lamports;
                }
                return transfer.copy(publicKey, publicKey2, l);
            }

            @NotNull
            public String toString() {
                return "Transfer(from=" + this.from + ", to=" + this.to + ", lamports=" + this.lamports + ")";
            }

            public int hashCode() {
                int result2 = this.from.hashCode();
                result2 = result2 * 31 + this.to.hashCode();
                result2 = result2 * 31 + Long.hashCode(this.lamports);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Transfer)) {
                    return false;
                }
                Transfer transfer = (Transfer)other;
                if (!Intrinsics.areEqual((Object)this.from, (Object)transfer.from)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.to, (Object)transfer.to)) {
                    return false;
                }
                return this.lamports == transfer.lamports;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001c"}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram$WithdrawNonceAccount;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$SystemProgram;", "nonceAccount", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "authorizedPubkey", "destination", "lamports", "", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;J)V", "getAuthorizedPubkey", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "getDestination", "getLamports", "()J", "getNonceAccount", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "solana-kotlin"})
        public static final class WithdrawNonceAccount
        extends SystemProgram {
            @NotNull
            private final PublicKey nonceAccount;
            @NotNull
            private final PublicKey authorizedPubkey;
            @NotNull
            private final PublicKey destination;
            private final long lamports;

            public WithdrawNonceAccount(@NotNull PublicKey nonceAccount, @NotNull PublicKey authorizedPubkey, @NotNull PublicKey destination, long lamports) {
                Intrinsics.checkNotNullParameter((Object)nonceAccount, (String)"nonceAccount");
                Intrinsics.checkNotNullParameter((Object)authorizedPubkey, (String)"authorizedPubkey");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                super(SystemProgram.Instruction.WithdrawNonceAccount.getIndex-pVg5ArA(), null);
                this.nonceAccount = nonceAccount;
                this.authorizedPubkey = authorizedPubkey;
                this.destination = destination;
                this.lamports = lamports;
            }

            @NotNull
            public final PublicKey getNonceAccount() {
                return this.nonceAccount;
            }

            @NotNull
            public final PublicKey getAuthorizedPubkey() {
                return this.authorizedPubkey;
            }

            @NotNull
            public final PublicKey getDestination() {
                return this.destination;
            }

            public final long getLamports() {
                return this.lamports;
            }

            @NotNull
            public final PublicKey component1() {
                return this.nonceAccount;
            }

            @NotNull
            public final PublicKey component2() {
                return this.authorizedPubkey;
            }

            @NotNull
            public final PublicKey component3() {
                return this.destination;
            }

            public final long component4() {
                return this.lamports;
            }

            @NotNull
            public final WithdrawNonceAccount copy(@NotNull PublicKey nonceAccount, @NotNull PublicKey authorizedPubkey, @NotNull PublicKey destination, long lamports) {
                Intrinsics.checkNotNullParameter((Object)nonceAccount, (String)"nonceAccount");
                Intrinsics.checkNotNullParameter((Object)authorizedPubkey, (String)"authorizedPubkey");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                return new WithdrawNonceAccount(nonceAccount, authorizedPubkey, destination, lamports);
            }

            public static /* synthetic */ WithdrawNonceAccount copy$default(WithdrawNonceAccount withdrawNonceAccount, PublicKey publicKey, PublicKey publicKey2, PublicKey publicKey3, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    publicKey = withdrawNonceAccount.nonceAccount;
                }
                if ((n & 2) != 0) {
                    publicKey2 = withdrawNonceAccount.authorizedPubkey;
                }
                if ((n & 4) != 0) {
                    publicKey3 = withdrawNonceAccount.destination;
                }
                if ((n & 8) != 0) {
                    l = withdrawNonceAccount.lamports;
                }
                return withdrawNonceAccount.copy(publicKey, publicKey2, publicKey3, l);
            }

            @NotNull
            public String toString() {
                return "WithdrawNonceAccount(nonceAccount=" + this.nonceAccount + ", authorizedPubkey=" + this.authorizedPubkey + ", destination=" + this.destination + ", lamports=" + this.lamports + ")";
            }

            public int hashCode() {
                int result2 = this.nonceAccount.hashCode();
                result2 = result2 * 31 + this.authorizedPubkey.hashCode();
                result2 = result2 * 31 + this.destination.hashCode();
                result2 = result2 * 31 + Long.hashCode(this.lamports);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WithdrawNonceAccount)) {
                    return false;
                }
                WithdrawNonceAccount withdrawNonceAccount = (WithdrawNonceAccount)other;
                if (!Intrinsics.areEqual((Object)this.nonceAccount, (Object)withdrawNonceAccount.nonceAccount)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.authorizedPubkey, (Object)withdrawNonceAccount.authorizedPubkey)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.destination, (Object)withdrawNonceAccount.destination)) {
                    return false;
                }
                return this.lamports == withdrawNonceAccount.lamports;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0019\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\n\u000b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\f"}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction$TokenProgram;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction;", "programIndex", "Lkotlin/UByte;", "(B)V", "getProgramIndex-w2LRezQ", "()B", "B", "Transfer", "TransferChecked", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$TokenProgram$Transfer;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$TokenProgram$TransferChecked;", "solana-kotlin"})
    public static abstract class TokenProgram
    extends DecodedInstruction {
        private final byte programIndex;

        private TokenProgram(byte programIndex) {
            super(net.avianlabs.solana.domain.program.TokenProgram.Companion.getProgramId(), null);
            this.programIndex = programIndex;
        }

        public final byte getProgramIndex-w2LRezQ() {
            return this.programIndex;
        }

        public /* synthetic */ TokenProgram(byte programIndex, DefaultConstructorMarker $constructor_marker) {
            this(programIndex);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001c"}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction$TokenProgram$Transfer;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$TokenProgram;", "source", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "destination", "owner", "amount", "", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;J)V", "getAmount", "()J", "getDestination", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "getOwner", "getSource", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "solana-kotlin"})
        public static final class Transfer
        extends TokenProgram {
            @NotNull
            private final PublicKey source;
            @NotNull
            private final PublicKey destination;
            @NotNull
            private final PublicKey owner;
            private final long amount;

            public Transfer(@NotNull PublicKey source, @NotNull PublicKey destination, @NotNull PublicKey owner, long amount) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                super(TokenProgram.Instruction.Transfer.getIndex-w2LRezQ(), null);
                this.source = source;
                this.destination = destination;
                this.owner = owner;
                this.amount = amount;
            }

            @NotNull
            public final PublicKey getSource() {
                return this.source;
            }

            @NotNull
            public final PublicKey getDestination() {
                return this.destination;
            }

            @NotNull
            public final PublicKey getOwner() {
                return this.owner;
            }

            public final long getAmount() {
                return this.amount;
            }

            @NotNull
            public final PublicKey component1() {
                return this.source;
            }

            @NotNull
            public final PublicKey component2() {
                return this.destination;
            }

            @NotNull
            public final PublicKey component3() {
                return this.owner;
            }

            public final long component4() {
                return this.amount;
            }

            @NotNull
            public final Transfer copy(@NotNull PublicKey source, @NotNull PublicKey destination, @NotNull PublicKey owner, long amount) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                return new Transfer(source, destination, owner, amount);
            }

            public static /* synthetic */ Transfer copy$default(Transfer transfer, PublicKey publicKey, PublicKey publicKey2, PublicKey publicKey3, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    publicKey = transfer.source;
                }
                if ((n & 2) != 0) {
                    publicKey2 = transfer.destination;
                }
                if ((n & 4) != 0) {
                    publicKey3 = transfer.owner;
                }
                if ((n & 8) != 0) {
                    l = transfer.amount;
                }
                return transfer.copy(publicKey, publicKey2, publicKey3, l);
            }

            @NotNull
            public String toString() {
                return "Transfer(source=" + this.source + ", destination=" + this.destination + ", owner=" + this.owner + ", amount=" + this.amount + ")";
            }

            public int hashCode() {
                int result2 = this.source.hashCode();
                result2 = result2 * 31 + this.destination.hashCode();
                result2 = result2 * 31 + this.owner.hashCode();
                result2 = result2 * 31 + Long.hashCode(this.amount);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Transfer)) {
                    return false;
                }
                Transfer transfer = (Transfer)other;
                if (!Intrinsics.areEqual((Object)this.source, (Object)transfer.source)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.destination, (Object)transfer.destination)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.owner, (Object)transfer.owner)) {
                    return false;
                }
                return this.amount == transfer.amount;
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\u0016\u0010\u001b\u001a\u00020\nH\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u000fJO\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\t\u001a\u00020\n\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006("}, d2={"Lnet/avianlabs/solana/domain/core/DecodedInstruction$TokenProgram$TransferChecked;", "Lnet/avianlabs/solana/domain/core/DecodedInstruction$TokenProgram;", "source", "Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "mint", "destination", "owner", "amount", "", "decimals", "Lkotlin/UByte;", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;JBLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getAmount", "()J", "getDecimals-w2LRezQ", "()B", "B", "getDestination", "()Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;", "getMint", "getOwner", "getSource", "component1", "component2", "component3", "component4", "component5", "component6", "component6-w2LRezQ", "copy", "copy-Q1Gd0Rw", "(Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;Lnet/avianlabs/solana/tweetnacl/ed25519/PublicKey;JB)Lnet/avianlabs/solana/domain/core/DecodedInstruction$TokenProgram$TransferChecked;", "equals", "", "other", "", "hashCode", "", "toString", "", "solana-kotlin"})
        public static final class TransferChecked
        extends TokenProgram {
            @NotNull
            private final PublicKey source;
            @NotNull
            private final PublicKey mint;
            @NotNull
            private final PublicKey destination;
            @NotNull
            private final PublicKey owner;
            private final long amount;
            private final byte decimals;

            private TransferChecked(PublicKey source, PublicKey mint, PublicKey destination, PublicKey owner, long amount, byte decimals) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)mint, (String)"mint");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                super(TokenProgram.Instruction.TransferChecked.getIndex-w2LRezQ(), null);
                this.source = source;
                this.mint = mint;
                this.destination = destination;
                this.owner = owner;
                this.amount = amount;
                this.decimals = decimals;
            }

            @NotNull
            public final PublicKey getSource() {
                return this.source;
            }

            @NotNull
            public final PublicKey getMint() {
                return this.mint;
            }

            @NotNull
            public final PublicKey getDestination() {
                return this.destination;
            }

            @NotNull
            public final PublicKey getOwner() {
                return this.owner;
            }

            public final long getAmount() {
                return this.amount;
            }

            public final byte getDecimals-w2LRezQ() {
                return this.decimals;
            }

            @NotNull
            public final PublicKey component1() {
                return this.source;
            }

            @NotNull
            public final PublicKey component2() {
                return this.mint;
            }

            @NotNull
            public final PublicKey component3() {
                return this.destination;
            }

            @NotNull
            public final PublicKey component4() {
                return this.owner;
            }

            public final long component5() {
                return this.amount;
            }

            public final byte component6-w2LRezQ() {
                return this.decimals;
            }

            @NotNull
            public final TransferChecked copy-Q1Gd0Rw(@NotNull PublicKey source, @NotNull PublicKey mint, @NotNull PublicKey destination, @NotNull PublicKey owner, long amount, byte decimals) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)mint, (String)"mint");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                return new TransferChecked(source, mint, destination, owner, amount, decimals, null);
            }

            public static /* synthetic */ TransferChecked copy-Q1Gd0Rw$default(TransferChecked transferChecked, PublicKey publicKey, PublicKey publicKey2, PublicKey publicKey3, PublicKey publicKey4, long l, byte by, int n, Object object) {
                if ((n & 1) != 0) {
                    publicKey = transferChecked.source;
                }
                if ((n & 2) != 0) {
                    publicKey2 = transferChecked.mint;
                }
                if ((n & 4) != 0) {
                    publicKey3 = transferChecked.destination;
                }
                if ((n & 8) != 0) {
                    publicKey4 = transferChecked.owner;
                }
                if ((n & 0x10) != 0) {
                    l = transferChecked.amount;
                }
                if ((n & 0x20) != 0) {
                    by = transferChecked.decimals;
                }
                return transferChecked.copy-Q1Gd0Rw(publicKey, publicKey2, publicKey3, publicKey4, l, by);
            }

            @NotNull
            public String toString() {
                return "TransferChecked(source=" + this.source + ", mint=" + this.mint + ", destination=" + this.destination + ", owner=" + this.owner + ", amount=" + this.amount + ", decimals=" + UByte.toString-impl((byte)this.decimals) + ")";
            }

            public int hashCode() {
                int result2 = this.source.hashCode();
                result2 = result2 * 31 + this.mint.hashCode();
                result2 = result2 * 31 + this.destination.hashCode();
                result2 = result2 * 31 + this.owner.hashCode();
                result2 = result2 * 31 + Long.hashCode(this.amount);
                result2 = result2 * 31 + UByte.hashCode-impl((byte)this.decimals);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TransferChecked)) {
                    return false;
                }
                TransferChecked transferChecked = (TransferChecked)other;
                if (!Intrinsics.areEqual((Object)this.source, (Object)transferChecked.source)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.mint, (Object)transferChecked.mint)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.destination, (Object)transferChecked.destination)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.owner, (Object)transferChecked.owner)) {
                    return false;
                }
                if (this.amount != transferChecked.amount) {
                    return false;
                }
                return this.decimals == transferChecked.decimals;
            }

            public /* synthetic */ TransferChecked(PublicKey source, PublicKey mint, PublicKey destination, PublicKey owner, long amount, byte decimals, DefaultConstructorMarker $constructor_marker) {
                this(source, mint, destination, owner, amount, decimals);
            }
        }
    }
}

