/*
 * Decompiled with CFR 0.152.
 */
package net.avianlabs.solana.domain.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.avianlabs.solana.domain.core.AccountMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u0014\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00060\tj\b\u0012\u0004\u0012\u00020\u0006`\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lnet/avianlabs/solana/domain/core/AccountKeysList;", "", "()V", "accounts", "Ljava/util/LinkedHashMap;", "", "Lnet/avianlabs/solana/domain/core/AccountMeta;", "Lkotlin/collections/LinkedHashMap;", "list", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getList", "()Ljava/util/ArrayList;", "add", "", "accountMeta", "addAll", "metas", "", "Companion", "solana-kotlin"})
public final class AccountKeysList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashMap<String, AccountMeta> accounts = new LinkedHashMap();
    @NotNull
    private static final Comparator<AccountMeta> metaComparator = AccountKeysList::metaComparator$lambda$0;

    public final void add(@NotNull AccountMeta accountMeta) {
        Intrinsics.checkNotNullParameter((Object)accountMeta, (String)"accountMeta");
        String key = accountMeta.getPublicKey().toString();
        AccountMeta existing = this.accounts.get(key);
        if (existing != null) {
            ((Map)this.accounts).put(key, AccountMeta.copy$default(existing, null, accountMeta.isSigner() || existing.isSigner(), accountMeta.isWritable() || existing.isWritable(), 1, null));
        } else {
            ((Map)this.accounts).put(key, accountMeta);
        }
    }

    public final void addAll(@NotNull Collection<AccountMeta> metas) {
        Intrinsics.checkNotNullParameter(metas, (String)"metas");
        for (AccountMeta meta : metas) {
            this.add(meta);
        }
    }

    @NotNull
    public final ArrayList<AccountMeta> getList() {
        ArrayList<AccountMeta> accountKeysList = new ArrayList<AccountMeta>(this.accounts.values());
        CollectionsKt.sortWith((List)accountKeysList, metaComparator);
        return accountKeysList;
    }

    private static final int metaComparator$lambda$0(AccountMeta am1, AccountMeta am2) {
        return am1.isSigner() && !am2.isSigner() ? -1 : (!am1.isSigner() && am2.isSigner() ? 1 : (am1.isWritable() && !am2.isWritable() ? -1 : (!am1.isWritable() && am2.isWritable() ? 1 : 0)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/avianlabs/solana/domain/core/AccountKeysList$Companion;", "", "()V", "metaComparator", "Ljava/util/Comparator;", "Lnet/avianlabs/solana/domain/core/AccountMeta;", "solana-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

