/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.sandbox;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;

public class Sandbox {
    private final File root;

    public Sandbox() {
        try {
            this.root = Sandbox.createTempDirectory();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create a sandbox", e);
        }
    }

    public File getRoot() {
        return this.root;
    }

    public File newFile(String filename) {
        return new File(this.getRoot(), filename);
    }

    private static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public void useResource(String resourceName) {
        this.useResource(resourceName, resourceName);
    }

    public void useResource(String resourceName, String filePath) {
        File file = new File(this.root, filePath);
        this.useResource(resourceName, file);
    }

    private void useResource(String resourceName, File file) {
        URL source = this.getResourceUrl(resourceName);
        try {
            FileUtils.copyURLToFile((URL)source, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load resource '" + resourceName + "'", e);
        }
    }

    private URL getResourceUrl(String resourceName) {
        URL source = Sandbox.class.getResource("/" + resourceName);
        if (source == null) {
            throw new RuntimeException("Unable to load resource '" + resourceName + "'");
        }
        return source;
    }
}

