/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.di.magnum;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.avh4.util.di.magnum.Provider;

public class ConstructorProvider<T>
implements Provider<T> {
    private final Class<T> componentClass;
    private final Constructor<T> constructor;

    public static <T> ConstructorProvider<T> forClass(Class<T> componentClass) {
        if (componentClass.isInterface()) {
            throw new RuntimeException("Can't create provider for interface: " + componentClass.getName());
        }
        if (componentClass.getConstructors().length == 0) {
            throw new RuntimeException("No accessible constructors: " + componentClass);
        }
        return new ConstructorProvider<T>(componentClass);
    }

    private ConstructorProvider(Class<T> componentClass) {
        this.componentClass = componentClass;
        this.constructor = this.findConstructor();
    }

    @Override
    public Class<T> getProvidedClass() {
        return this.componentClass;
    }

    @Override
    public Class<?>[] getDependencyTypes() {
        return this.constructor.getParameterTypes();
    }

    @Override
    public T get(Object ... dependencies) {
        try {
            return this.constructor.newInstance(dependencies);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Can't instantiate " + this.componentClass, e);
        }
    }

    private Constructor<T> findConstructor() {
        Constructor<?> constructor = this.componentClass.getConstructors()[0];
        return constructor;
    }

    public String toString() {
        return "ConstructorProvider<" + this.componentClass.getCanonicalName() + '>';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstructorProvider that = (ConstructorProvider)o;
        return !(this.componentClass != null ? !this.componentClass.equals(that.componentClass) : that.componentClass != null);
    }

    public int hashCode() {
        return this.componentClass != null ? this.componentClass.hashCode() : 0;
    }
}

