/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.di.magnum;

import net.avh4.util.di.magnum.GenerationTag;
import net.avh4.util.di.magnum.Provider;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

public class Module {
    private final PMap<Class<?>, GenerationTag<Provider<?>>> map;
    private final int generation;

    public Module() {
        this.map = HashTreePMap.empty();
        this.generation = 0;
    }

    private Module(PMap<Class<?>, GenerationTag<Provider<?>>> map, int generation) {
        this.map = map;
        this.generation = generation;
    }

    public GenerationTag<Provider<?>> getProvider(Object componentKey) {
        return (GenerationTag)this.map.get(componentKey);
    }

    public <T> Module add(Provider<T> provider) {
        if (provider == null) {
            return this;
        }
        Class<T> providedClass = provider.getProvidedClass();
        if (providedClass == null) {
            throw new RuntimeException("Provider does not provide a key--you must implement getProvidedClass(): " + provider);
        }
        return this.add(providedClass, provider);
    }

    private <T> Module add(Class<T> componentKey, Provider<? extends T> provider) {
        PMap newProviders = this.map.plus(componentKey, new GenerationTag<Provider<? extends T>>(this.generation, provider));
        return new Module(newProviders, this.generation);
    }

    public Module nextGeneration() {
        return new Module(this.map, this.generation + 1);
    }
}

