/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.di.magnum;

import net.avh4.util.di.magnum.Cache;
import net.avh4.util.di.magnum.GenerationTag;
import net.avh4.util.di.magnum.KeyMap;
import net.avh4.util.di.magnum.Module;
import net.avh4.util.di.magnum.Provider;
import net.avh4.util.di.magnum.ProviderFactory;
import net.avh4.util.di.magnum.StandardProviderFactory;

public class MagnumDI {
    private final ProviderFactory factory;
    private final KeyMap keyMap;
    private final Module module;
    private final Cache cache;

    public MagnumDI() {
        this.keyMap = new KeyMap();
        this.module = new Module();
        this.factory = new StandardProviderFactory();
        this.cache = new Cache();
    }

    public MagnumDI(Object ... components_classOrInstanceOrProvider) {
        MagnumDI template = new MagnumDI().add(components_classOrInstanceOrProvider);
        this.keyMap = template.keyMap;
        this.module = template.module;
        this.factory = template.factory;
        this.cache = template.cache;
    }

    private MagnumDI(ProviderFactory factory, KeyMap keyMap, Module module, Cache cache) {
        this.factory = factory;
        this.keyMap = keyMap;
        this.module = module;
        this.cache = cache;
    }

    public MagnumDI add(Object ... components_classOrInstanceOrProvider) {
        KeyMap keyMap = this.keyMap;
        Module module = this.module.nextGeneration();
        Cache cache = new Cache(this.cache);
        for (Object component : components_classOrInstanceOrProvider) {
            Provider<?> provider = this.factory.getProvider(component);
            Class<?> key = provider.getProvidedClass();
            keyMap = keyMap.add(key);
            module = module.add(provider);
        }
        return new MagnumDI(this.factory, keyMap, module, cache);
    }

    public <T> T get(Class<T> componentKey) {
        if (this.keyMap.getBestMatch(componentKey) == null) {
            return this.add(componentKey).get(componentKey);
        }
        return this.getWithExceptionReporting(componentKey).object;
    }

    private <T> GenerationTag<T> getWithExceptionReporting(Class<T> componentKey) {
        try {
            return this.getWithoutAdding(componentKey);
        }
        catch (RuntimeException e) {
            String prefix = "";
            Throwable cause = e.getCause();
            if (e.getClass() != RuntimeException.class) {
                prefix = e.getClass().getCanonicalName() + ": ";
                cause = e;
            }
            throw new RuntimeException(prefix + e.getMessage() + "\n        While getting dependency " + componentKey, cause);
        }
    }

    public <T> GenerationTag<T> getWithoutAdding(Class<T> componentKey) {
        if (componentKey == MagnumDI.class) {
            return new GenerationTag<MagnumDI>(-1, this);
        }
        Object key = this.getBestKey(componentKey);
        return this.getFromCacheOrCreateFromProvider(key);
    }

    private <T> GenerationTag<T> getFromCacheOrCreateFromProvider(Object key) {
        GenerationTag<Object> cacheResult = this.cache.get(key);
        if (cacheResult != null) {
            return cacheResult;
        }
        GenerationTag<T> taggedInstance = this.createFromProvider(key);
        this.cache.add(key, taggedInstance.object, taggedInstance.generation);
        return taggedInstance;
    }

    private <T> GenerationTag<T> createFromProvider(Object key) {
        GenerationTag<Provider<?>> taggedProvider = this.module.getProvider(key);
        Provider provider = (Provider)taggedProvider.object;
        Class<?>[] dependencyTypes = provider.getDependencyTypes();
        if (dependencyTypes == null) {
            throw new RuntimeException("Provider must implements getDependencyTypes(): " + provider);
        }
        GenerationTag<Object[]> taggedDependencies = this.getDependencies(dependencyTypes);
        Object[] dependencies = (Object[])taggedDependencies.object;
        Object instance = provider.get(dependencies);
        int youngestGeneration = Math.max(taggedDependencies.generation, taggedProvider.generation);
        return new GenerationTag(youngestGeneration, instance);
    }

    private <T> Object getBestKey(Class<T> componentKey) {
        Object key = this.keyMap.getBestMatch(componentKey);
        if (key == null) {
            throw new RuntimeException("No provider for key: " + componentKey);
        }
        if (key instanceof KeyMap.AmbiguousKey) {
            throw new RuntimeException("Multiple matches for " + componentKey + ":\n        " + ((KeyMap.AmbiguousKey)key).keys());
        }
        return key;
    }

    private GenerationTag<Object[]> getDependencies(Class<?>[] dependencyTypes) {
        int youngestGeneration = 0;
        Object[] dependencies = new Object[dependencyTypes.length];
        for (int i = 0; i < dependencyTypes.length; ++i) {
            Class<?> dependencyType = dependencyTypes[i];
            GenerationTag<?> taggedDependency = this.getWithExceptionReporting(dependencyType);
            youngestGeneration = Math.max(youngestGeneration, taggedDependency.generation);
            dependencies[i] = taggedDependency.object;
        }
        return new GenerationTag<Object[]>(youngestGeneration, dependencies);
    }
}

