/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.di.magnum;

import net.avh4.util.di.magnum.GenerationTag;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

public class Cache {
    private final Cache parent;
    private final int generation;
    private PMap<Object, Object> map;

    public Cache() {
        this.parent = null;
        this.generation = 0;
        this.map = HashTreePMap.empty();
    }

    public Cache(Cache parent) {
        this.parent = parent;
        this.generation = parent.generation + 1;
        this.map = HashTreePMap.empty();
    }

    public GenerationTag<Object> get(Object key) {
        Object instance = this.map.get(key);
        if (instance != null) {
            return new GenerationTag<Object>(this.generation, instance);
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.get(key);
    }

    public void add(Object key, Object instance, int generation) {
        if (generation > this.generation) {
            throw new IllegalArgumentException("Requested generation (" + generation + ") is not known to this Cache: " + this);
        }
        if (generation < 0) {
            throw new IllegalArgumentException("generation must be >= 0");
        }
        if (generation == this.generation) {
            this.map = this.map.plus(key, instance);
        } else {
            this.parent.add(key, instance, generation);
        }
    }

    public String toString() {
        return "Cache{generation=" + this.generation + '}';
    }
}

