/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.demo.uilayer;

import net.avh4.framework.uilayer.Color;
import net.avh4.framework.uilayer.Font;
import net.avh4.framework.uilayer.TimerUpdate;
import net.avh4.framework.uilayer.UI;
import net.avh4.framework.uilayer.UILayer;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.math.geometry.Point;
import net.avh4.math.geometry.Rect;

public class SliderDemo
implements UI {
    public static final int SLIDER_HEIGHT = 50;
    private double hue = 0.0;
    private double saturation = 0.5;
    private double lightness = 0.5;
    private final Atom<Double> hueAtom = new Atom<Double>(){

        @Override
        public void swap(Double newValue) {
            SliderDemo.this.hue = newValue * 360.0;
        }
    };
    private final Atom<Double> saturationAtom = new Atom<Double>(){

        @Override
        public void swap(Double newValue) {
            SliderDemo.this.saturation = newValue;
        }
    };
    private final Atom<Double> lightnessAtom = new Atom<Double>(){

        @Override
        public void swap(Double newValue) {
            SliderDemo.this.lightness = newValue;
        }
    };

    public static void main(String[] args) {
        UILayer.main((UI)new SliderDemo());
    }

    public void click(Rect bounds, Point point) {
        Rect sliderBounds = bounds.resizeFromCenter(300.0, 150.0);
        this.clickSlider(sliderBounds.top(50.0), point, this.hueAtom);
        this.clickSlider(sliderBounds.top(50.0).translate(0, 50), point, this.saturationAtom);
        this.clickSlider(sliderBounds.top(50.0).translate(0, 100), point, this.lightnessAtom);
    }

    public void move(Rect bounds, Point point) {
        Rect sliderBounds = bounds.resizeFromCenter(300.0, 150.0);
        this.clickSlider(sliderBounds.top(50.0), point, this.hueAtom);
        this.clickSlider(sliderBounds.top(50.0).translate(0, 50), point, this.saturationAtom);
        this.clickSlider(sliderBounds.top(50.0).translate(0, 100), point, this.lightnessAtom);
    }

    private void clickSlider(Rect bounds, Point point, Atom<Double> state) {
        Rect barBounds = bounds.inset(20.0).inset(0.0, 0.0, 50.0, 0.0);
        if (bounds.contains(point)) {
            double v = barBounds.toPercentX(point.x());
            state.swap(Math.max(0.0, Math.min(1.0, v)));
        }
    }

    public void draw(Rect bounds, GraphicsOperations g, FontMetricsService fm) {
        g.drawRect(bounds.inset(10.0), Color.fromHSL((double)this.hue, (double)this.saturation, (double)this.lightness));
        Rect sliderBounds = bounds.resizeFromCenter(300.0, 150.0);
        this.drawSlider(g, sliderBounds.top(50.0), this.hue / 360.0);
        this.drawSlider(g, sliderBounds.top(50.0).translate(0, 50), this.saturation);
        this.drawSlider(g, sliderBounds.top(50.0).translate(0, 100), this.lightness);
    }

    private void drawSlider(GraphicsOperations g, Rect bounds, double percent) {
        Rect barFrame = bounds.inset(20.0).inset(0.0, 0.0, 50.0, 0.0);
        Rect textBounds = bounds.right(50.0);
        g.drawRect(bounds.inset(5.0), Color.fromHSL((double)0.0, (double)0.0, (double)1.0));
        Rect barRect = barFrame.resizeFromCenter(barFrame.width(), 1.0);
        g.drawRect(barRect, -16777216);
        double x = barFrame.percentX(percent);
        Rect handleBounds = Rect.fromCenter((double)x, (double)barFrame.midY(), (double)20.0, (double)20.0);
        g.drawOval(handleBounds, -12566464);
        String text = String.format("%.2f", percent);
        g.drawText(text, textBounds.minX(), textBounds.midY(), Font.OPEN_SANS, -16777216);
    }

    public void key(int keyCode, boolean shift) {
    }

    public TimerUpdate.UpdateAction time() {
        return TimerUpdate.UpdateAction.NO_UPDATE;
    }

    public static interface Atom<T> {
        public void swap(T var1);
    }
}

