/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.demo.uilayer;

import net.avh4.framework.uilayer.AspectRatioContext;
import net.avh4.framework.uilayer.Color;
import net.avh4.framework.uilayer.Element;
import net.avh4.framework.uilayer.TimerUpdate;
import net.avh4.framework.uilayer.UI;
import net.avh4.framework.uilayer.UILayer;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.framework.uilayer.scene.SceneOval;
import net.avh4.framework.uilayer.scene.ScenePlaceholder;
import net.avh4.framework.uilayer.scene.SceneRect;
import net.avh4.math.geometry.Point;
import net.avh4.math.geometry.Rect;

public class PongGame
implements UI {
    private final SceneRect paddle1 = new SceneRect(Color.fromHSL((double)25.0, (double)0.6, (double)0.25));
    private final SceneRect paddle2 = new SceneRect(Color.fromHSL((double)25.0, (double)0.6, (double)0.25));
    private final SceneOval ball = new SceneOval(Color.fromHSL((double)50.0, (double)0.0, (double)1.0));
    private double paddle1Y = 300.0;
    private double paddle2Y = 300.0;
    private double lastTapX;
    private double lastTapY;
    private double ballX = 400.0;
    private double ballY = 300.0;

    public static void main(String[] args) {
        UILayer.main((UI)new PongGame());
    }

    public void click(Rect bounds, Point p) {
        this.click2(bounds.divide(0.0, 0.0, 0.5, 1.0), p);
        this.click2(bounds.divide(0.5, 0.0, 1.0, 0.5), p);
        this.click2(bounds.divide(0.5, 0.5, 1.0, 1.0), p);
    }

    public void move(Rect bounds, Point p) {
    }

    private void click2(Rect bounds, Point p) {
        Rect tap = Rect.fromCenter((Point)p, (double)0.0, (double)0.0);
        Rect tinyGame = bounds.aspectRatio(800.0, 600.0);
        if (tinyGame.contains(tap)) {
            Rect tapInReferenceSpace = tap.translate(Rect.ofSize((double)0.0, (double)0.0), tinyGame).scale(tinyGame.size(), Rect.ofSize((double)800.0, (double)600.0));
            this.click(tapInReferenceSpace.midX(), tapInReferenceSpace.midY());
        }
    }

    private void click(double referenceX, double referenceY) {
        this.lastTapX = referenceX;
        this.lastTapY = referenceY;
    }

    public void draw(Rect bounds, GraphicsOperations g, FontMetricsService fm) {
        g.drawRect(bounds, -16777216);
        this.draw2(bounds.divide(0.0, 0.0, 0.5, 1.0), Color.fromHSL((double)205.0, (double)0.5, (double)0.5), g, fm);
        this.draw2(bounds.divide(0.5, 0.0, 1.0, 0.5), Color.fromHSL((double)350.0, (double)0.3, (double)0.5), g, fm);
        this.draw2(bounds.divide(0.5, 0.5, 1.0, 1.0), Color.fromHSL((double)350.0, (double)0.3, (double)0.4), g, fm);
    }

    private void draw2(Rect divide, int backgroundColor, GraphicsOperations g, FontMetricsService fm) {
        g.drawRect(divide, backgroundColor);
        AspectRatioContext context = new AspectRatioContext(800.0, 600.0, divide, g, fm);
        this.draw(context);
    }

    private void draw(AspectRatioContext context) {
        context.draw(Rect.fromTopLeft((double)0.0, (double)0.0, (double)800.0, (double)600.0), (Element)new SceneRect(Color.fromHSL((double)120.0, (double)0.4, (double)0.25)));
        context.draw(Rect.fromTopLeft((double)0.0, (double)0.0, (double)800.0, (double)600.0).inset(5.0), (Element)new ScenePlaceholder("(Grass Texture)"));
        context.draw(Rect.fromCenter((double)this.ballX, (double)this.ballY, (double)25.0, (double)25.0), (Element)this.ball);
        context.draw(Rect.fromCenter((double)30.0, (double)this.paddle1Y, (double)10.0, (double)105.0), (Element)this.paddle1);
        context.draw(Rect.fromCenter((double)770.0, (double)this.paddle2Y, (double)10.0, (double)105.0), (Element)this.paddle2);
        context.draw(Rect.fromCenter((double)this.lastTapX, (double)this.lastTapY, (double)20.0, (double)20.0), (Element)new SceneOval(Color.fromHSL((double)345.0, (double)0.4, (double)0.7)));
    }

    public void key(int keyCode, boolean shift) {
        switch (keyCode) {
            case 38: {
                this.paddle2Y -= 5.0;
                break;
            }
            case 40: {
                this.paddle2Y += 5.0;
                break;
            }
            case 87: {
                this.paddle1Y -= 5.0;
                break;
            }
            case 83: {
                this.paddle1Y += 5.0;
            }
        }
    }

    public TimerUpdate.UpdateAction time() {
        this.ballX += 3.0;
        return NEEDS_REDRAW;
    }
}

