/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.demo.uilayer;

import net.avh4.framework.uilayer.Element;
import net.avh4.framework.uilayer.UILayer;
import net.avh4.framework.uilayer.mvc.View;
import net.avh4.framework.uilayer.mvc.ViewController;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.framework.uilayer.scene.Scene;
import net.avh4.framework.uilayer.scene.ScenePlaceholder;
import net.avh4.math.geometry.Point;
import net.avh4.math.geometry.Rect;

public class LightswitchGame
implements ViewController<Model> {
    public static void main(String[] args) {
        LightswitchGame vc = new LightswitchGame();
        UILayer.main((Object)new Model(), (View)vc);
    }

    public void click(Model model, Point p) {
        model.lightsOn = !model.lightsOn;
    }

    public void key(Model model, int keyCode, boolean shift) {
    }

    private Scene getScene(Model model, Rect bounds) {
        Scene scene = new Scene("Lightswitch");
        if (model.lightsOn) {
            scene.add(bounds, (Element)new ScenePlaceholder("Room"));
        } else {
            scene.add(bounds, (Element)new ScenePlaceholder("Blackness", -16777216));
        }
        scene.add(Rect.fromTopLeft((double)300.0, (double)400.0, (double)10.0, (double)17.0), (Element)new ScenePlaceholder("Switch", -1));
        return scene;
    }

    public void draw(Model model, Rect bounds, GraphicsOperations g, FontMetricsService fm) {
        this.getScene(model, bounds).draw(bounds, g, fm);
    }

    public static class Model {
        private boolean lightsOn;
    }
}

