/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.demo.uilayer;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import net.avh4.framework.uilayer.TimerUpdate;
import net.avh4.framework.uilayer.UI;
import net.avh4.framework.uilayer.UILayer;
import net.avh4.framework.uilayer.layout.BoundsTransformation;
import net.avh4.framework.uilayer.layout.Layout;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.framework.uilayer.scene.ScenePlaceholder;
import net.avh4.math.geometry.Point;
import net.avh4.math.geometry.Rect;

public class LayoutDemo
implements UI {
    private final Layout<String> layout = new EventVerticalLayout<String>("A", "B", "C");

    public static void main(String[] args) {
        UILayer.main((UI)new LayoutDemo());
    }

    public void click(Rect bounds, Point p) {
    }

    public void move(Rect bounds, Point p) {
    }

    public void draw(Rect bounds, GraphicsOperations g, FontMetricsService fm) {
        for (String key : ImmutableList.of((Object)"A", (Object)"B", (Object)"C")) {
            Rect b = this.layout.get((Object)key).apply(bounds);
            new ScenePlaceholder(key).draw(b, g, fm);
        }
    }

    public void key(int keyCode, boolean shift) {
    }

    public TimerUpdate.UpdateAction time() {
        return TimerUpdate.UpdateAction.NO_UPDATE;
    }

    public static class EventVerticalLayout<T>
    implements Layout<T> {
        private final List<T> items;

        public EventVerticalLayout(T ... items) {
            this.items = Arrays.asList(items);
        }

        public BoundsTransformation get(T key) {
            final int index = this.items.indexOf(key);
            if (index == -1) {
                return null;
            }
            final int n = this.items.size();
            return new BoundsTransformation(){

                public Rect apply(Rect bounds) {
                    return bounds.divide(0.0, (double)index / (double)n, 1.0, (double)(index + 1) / (double)n);
                }
            };
        }
    }
}

