/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.demo.uilayer;

import net.avh4.framework.uilayer.Color;
import net.avh4.framework.uilayer.Element;
import net.avh4.framework.uilayer.ElementBoundsAnimator;
import net.avh4.framework.uilayer.TimeService;
import net.avh4.framework.uilayer.TimerUpdate;
import net.avh4.framework.uilayer.UI;
import net.avh4.framework.uilayer.UILayer;
import net.avh4.framework.uilayer.animation.AnimatedBoolean;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.math.geometry.Point;
import net.avh4.math.geometry.Rect;

public class FavoriteColors
implements UI {
    private static final int NUM_ROWS = 6;
    private static final int NUM_COLS = 5;
    private final ColorElement[][] colors = new ColorElement[5][6];
    private final ElementBoundsAnimator animator = new ElementBoundsAnimator(new TimeService());

    public FavoriteColors() {
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 5; ++col) {
                double hue = 360.0 * (double)((7 * col + 11 * row + 3) % 12) / 12.0;
                double lightness = 0.3 + 0.7 * ((double)row + 0.5) / 6.0;
                this.colors[col][row] = new ColorElement(Color.fromHSL((double)hue, (double)1.0, (double)lightness));
            }
        }
    }

    public static void main(String[] args) {
        UILayer.main((UI)new FavoriteColors());
    }

    public void click(Rect bounds, Point p) {
        int col = (int)(p.x() * 5.0 / bounds.width());
        int row = (int)(p.y() * 6.0 / bounds.height());
        this.colors[col][row].dismiss();
    }

    public void move(Rect bounds, Point p) {
    }

    public void draw(Rect bounds, GraphicsOperations g, FontMetricsService fm) {
        g.drawRect(bounds, -1);
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 5; ++col) {
                Rect colorBounds = bounds.divide((double)col / 5.0, (double)row / 6.0, ((double)col + 1.0) / 5.0, ((double)row + 1.0) / 6.0);
                this.animator.updateElement(colorBounds, (Element)this.colors[col][row]);
            }
        }
        this.animator.render(g, fm);
    }

    public void key(int keyCode, boolean shift) {
    }

    public TimerUpdate.UpdateAction time() {
        return NEEDS_REDRAW;
    }

    public static class ColorElement
    implements Element {
        private final int color;
        private final AnimatedBoolean dismissed = new AnimatedBoolean(5000);

        public ColorElement(int color) {
            this.color = color;
        }

        public void draw(Rect bounds, GraphicsOperations g, FontMetricsService fm) {
            Rect rect = Rect.interpolate((Rect)bounds.inset(Math.sqrt(bounds.area()) / 50.0), (Rect)bounds.resizeFromCenter(5.0, 5.0), (double)this.dismissed.get());
            g.drawRect(rect, this.color);
        }

        public void dismiss() {
            this.dismissed.set(true);
        }
    }
}

