/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.demo.uilayer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.avh4.framework.async.Function;
import net.avh4.framework.async.Promise;
import net.avh4.framework.data.File;
import net.avh4.framework.uilayer.Element;
import net.avh4.framework.uilayer.TimerUpdate;
import net.avh4.framework.uilayer.UI;
import net.avh4.framework.uilayer.UILayer;
import net.avh4.framework.uilayer.UILayerService;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.framework.uilayer.scene.Scene;
import net.avh4.framework.uilayer.scene.ScenePlaceholder;
import net.avh4.math.geometry.Point;
import net.avh4.math.geometry.Rect;

public class ChooserDemo
implements UI {
    private final UILayerService service;
    private String chosenString;
    private File chosenFile;

    public static void main(String[] args) {
        UILayer.main((UI)new ChooserDemo(UILayer.service));
    }

    public ChooserDemo(UILayerService service) {
        this.service = service;
    }

    public void click(Rect bounds, Point p) {
        if (p.x() < 400.0) {
            this.chooseString();
        } else {
            this.chooseFile();
        }
    }

    public void move(Rect bounds, Point p) {
    }

    private void chooseString() {
        Promise choice = this.service.showChoices("Choose from among our fine strings", (List)ImmutableList.of((Object)"fine", (Object)"FINE", (Object)"F1N3", (Object)"F\u00edn\u00e8"));
        choice.whenDone((Function)new Function<String, Void>(){

            public Void apply(String s) {
                ChooserDemo.this.chosenString = s;
                return null;
            }
        });
    }

    private void chooseFile() {
        Promise choice = this.service.showFileChooser("Choose from among our fine files");
        choice.whenDone((Function)new Function<File, Void>(){

            public Void apply(File file) {
                ChooserDemo.this.chosenFile = file;
                return null;
            }
        });
    }

    public void key(int keyCode, boolean shift) {
        if (keyCode == 83) {
            this.chooseString();
        }
        if (keyCode == 70) {
            this.chooseFile();
        }
    }

    public Scene getScene(Rect bounds) {
        Scene scene = new Scene("Chooser Demo");
        scene.add(bounds.divide(0.0, 0.0, 0.5, 0.5).inset(5.0), (Element)new ScenePlaceholder("Choose a string (s)"));
        scene.add(bounds.divide(0.5, 0.0, 1.0, 0.5).inset(5.0), (Element)new ScenePlaceholder("Choose a file (f)"));
        if (this.chosenString != null) {
            scene.add(bounds.divide(0.0, 0.5, 0.5, 1.0).inset(5.0), (Element)new ScenePlaceholder(this.chosenString));
        }
        if (this.chosenFile != null) {
            scene.add(bounds.divide(0.5, 0.5, 1.0, 1.0).inset(5.0), (Element)new ScenePlaceholder(this.chosenFile.getName()));
        }
        return scene;
    }

    public void draw(Rect bounds, GraphicsOperations g, FontMetricsService fm) {
        this.getScene(bounds).draw(bounds, g, fm);
    }

    public TimerUpdate.UpdateAction time() {
        return NO_UPDATE;
    }
}

