/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import net.avh4.framework.uilayer.Element;
import net.avh4.framework.uilayer.Font;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.math.geometry.Rect;

public class SceneText
implements Element {
    protected String text;
    protected final Font font;
    protected final int color;

    public SceneText(String text, Font customFont, int color) {
        this.text = text;
        this.color = color;
        this.font = customFont;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void draw(Rect bounds, GraphicsOperations g, FontMetricsService fm) {
        String[] words;
        int MAX_HEIGHT = 2000;
        float lineHeight = fm.getLineHeight(this.font);
        double curX = bounds.minX();
        double curY = bounds.minY() + (double)fm.getAscent(this.font);
        for (String word : words = this.text.replaceAll("\n", " ").split(" ")) {
            float wordWidth = fm.stringWidth(this.font, word);
            if (curX + (double)wordWidth > bounds.minX() + bounds.width()) {
                curY += (double)lineHeight;
                curX = bounds.minX();
                if (curY >= (double)((float)MAX_HEIGHT + lineHeight)) {
                    return;
                }
            }
            g.drawText(word, curX, curY, this.font, this.color);
            curX += (double)fm.stringWidth(this.font, word + " ");
        }
    }

    public String toString() {
        return "SceneText{text='" + this.text + '\'' + ", font=" + this.font + ", color=" + this.color + '}';
    }
}

